/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.editmodel;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.editmodel.EditModelCommandStack;
import org.eclipse.bpel.common.ui.editmodel.IEditModelListener;
import org.eclipse.bpel.common.ui.editmodel.IResourceSetProvider;
import org.eclipse.bpel.common.ui.editmodel.ResourceInfo;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class EditModel {
    protected static EditModelCache cache = new EditModelCache();
    protected Map<IFile, ResourceInfo> fileToResourceInfo = new HashMap<IFile, ResourceInfo>();
    protected ResourceSet resourceSet;
    protected int referenceCount = 0;
    protected IResource primaryFile;
    protected EditModelCommandStack commandStack;
    private List<IEditModelListener> updateListeners = null;
    static ResourceInfo[] EMPTY_RESOURCE_ARRAY = new ResourceInfo[0];
    static String EXTPT_RESOURCE_SET_PROVIDER = "resourceSetProvider";
    static String ELM_PROVIDER = "provider";
    static String ATT_CLASS = "class";
    private static IResourceSetProvider gfResourceSetProvider;

    public static EditModel getEditModel(IResource primaryFile) {
        return cache.getEditModel(primaryFile, new Factory());
    }

    public static EditModel getEditModel(IResource primaryFile, Factory factory) {
        return cache.getEditModel(primaryFile, factory);
    }

    protected EditModel(ResourceSet rSet, IResource bpelFile) {
        this.resourceSet = rSet;
        this.primaryFile = bpelFile;
        this.updateListeners = new ArrayList<IEditModelListener>();
    }

    public void addListener(IEditModelListener listener) {
        if (this.updateListeners.contains(listener)) {
            return;
        }
        this.updateListeners.add(listener);
    }

    public void removeListener(IEditModelListener listener) {
        this.updateListeners.remove(listener);
    }

    protected void fireModelDirtyStateChanged(ResourceInfo sr) {
        for (IEditModelListener next : this.updateListeners) {
            next.modelDirtyStateChanged(sr);
        }
    }

    protected void fireModelDeleted(ResourceInfo sr) {
        ArrayList<IEditModelListener> listeners = new ArrayList<IEditModelListener>(this.updateListeners.size());
        listeners.addAll(this.updateListeners);
        for (IEditModelListener next : listeners) {
            next.modelDeleted(sr);
        }
    }

    protected void fireModelReloaded(ResourceInfo sr) {
        ArrayList<IEditModelListener> listeners = new ArrayList<IEditModelListener>(this.updateListeners.size());
        listeners.addAll(this.updateListeners);
        for (IEditModelListener next : listeners) {
            next.modelReloaded(sr);
        }
    }

    protected void fireModelLocationChanged(ResourceInfo sr, IFile movedToFile) {
        ArrayList<IEditModelListener> listeners = new ArrayList<IEditModelListener>(this.updateListeners.size());
        listeners.addAll(this.updateListeners);
        for (IEditModelListener next : listeners) {
            next.modelLocationChanged(sr, movedToFile);
        }
    }

    protected void fireModelMarkersChanged(ResourceInfo sr, IMarkerDelta[] markerDelta) {
        ArrayList<IEditModelListener> listeners = new ArrayList<IEditModelListener>(this.updateListeners.size());
        listeners.addAll(this.updateListeners);
        for (IEditModelListener next : listeners) {
            next.modelMarkersChanged(sr, markerDelta);
        }
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    ResourceInfo getResourceInfoForLoadedResource(Resource resource) {
        URI uri = resource.getURI();
        IFile file = EditModel.getIFileForURI(uri);
        if (file == null) {
            return null;
        }
        ResourceInfo resourceInfo = this.fileToResourceInfo.get(file);
        if (resourceInfo == null) {
            resourceInfo = new ResourceInfo(this, file);
            resourceInfo.setResource(resource);
            this.addResourceInfo(resourceInfo);
            resourceInfo.resourceLoaded();
        }
        if (!resourceInfo.loading) {
            ++resourceInfo.referenceCount;
        }
        return resourceInfo;
    }

    public ResourceInfo getResourceInfo(IFile file) {
        ResourceInfo resourceInfo = this.fileToResourceInfo.get(file);
        if (resourceInfo == null) {
            resourceInfo = new ResourceInfo(this, file);
            this.addResourceInfo(resourceInfo);
            try {
                resourceInfo.load();
            }
            catch (RuntimeException ex) {
                ++resourceInfo.referenceCount;
                this.releaseReference(resourceInfo);
                throw ex;
            }
        }
        ++resourceInfo.referenceCount;
        return resourceInfo;
    }

    public ResourceInfo[] getResourceInfos() {
        return this.fileToResourceInfo.values().toArray(EMPTY_RESOURCE_ARRAY);
    }

    private void setPrimaryFile(IFile newFile) {
        IResource oldFile = this.primaryFile;
        this.primaryFile = newFile;
        cache.updatePrimaryFile(oldFile, (IResource)newFile);
    }

    public IResource getPrimaryFile() {
        return this.primaryFile;
    }

    public void releaseReference(ResourceInfo resourceInfo) {
        --resourceInfo.referenceCount;
        if (resourceInfo.referenceCount == 0) {
            resourceInfo.dispose();
            this.removeResourceInfo(resourceInfo);
        }
    }

    protected void addResourceInfo(ResourceInfo sr) {
        this.fileToResourceInfo.put(sr.getFile(), sr);
    }

    protected void removeResourceInfo(ResourceInfo sr) {
        this.fileToResourceInfo.remove(sr.getFile());
    }

    public void release() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            cache.remove(this);
            ResourceInfo[] resourceInfoArray = this.fileToResourceInfo.values().toArray(EMPTY_RESOURCE_ARRAY);
            int n = resourceInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceInfo resourceInfo = resourceInfoArray[n2];
                resourceInfo.dispose();
                ++n2;
            }
            this.fileToResourceInfo.clear();
        }
    }

    public static IFile getIFileForURI(URI uri) {
        String filePath = null;
        String scheme = uri.scheme();
        IFile file = null;
        if ("file".equals(scheme)) {
            filePath = uri.toFileString();
            if (filePath == null) {
                return null;
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        } else if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = uri.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(i));
                ++i;
            }
            filePath = platformResourcePath.toString();
            if (filePath == null) {
                return null;
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        }
        return file;
    }

    public EditModelCommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setCommandStack(EditModelCommandStack stack) {
        this.commandStack = stack;
    }

    public boolean saveAll(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                EditModel.this.getCommandStack().markSaveLocation();
                try {
                    ResourceInfo[] sResource = EditModel.this.getResourceInfos();
                    int i = 0;
                    while (i < sResource.length) {
                        ResourceInfo resource = sResource[i];
                        if (resource.isDirty()) {
                            resource.save();
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            operation.run(progressMonitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean savePrimaryResourceAs(ResourceInfo resourceInfo, IFile savedFile, IProgressMonitor progressMonitor) {
        boolean result = this.saveResourceAs(resourceInfo, savedFile, progressMonitor);
        if (result) {
            this.setPrimaryFile(savedFile);
        }
        return result;
    }

    public boolean saveResourceAs(final ResourceInfo resourceInfo, final IFile savedFile, IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    EditModel.this.getCommandStack().markSaveLocation();
                    resourceInfo.saveAs(savedFile);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            operation.run(progressMonitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    static IResourceSetProvider getResourceSetProvider() {
        if (gfResourceSetProvider != null) {
            return gfResourceSetProvider;
        }
        IConfigurationElement[] iConfigurationElementArray = CommonUIPlugin.getConfigurationElements(EXTPT_RESOURCE_SET_PROVIDER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elm = iConfigurationElementArray[n2];
            if (ELM_PROVIDER.equals(elm.getName())) {
                String clazz = elm.getAttribute(ATT_CLASS);
                if (clazz != null) {
                    try {
                        gfResourceSetProvider = (IResourceSetProvider)elm.createExecutableExtension(ATT_CLASS);
                    }
                    catch (CoreException ce) {
                        CommonUIPlugin.getDefault().getLog().log(ce.getStatus());
                    }
                }
                if (gfResourceSetProvider != null) break;
            }
            ++n2;
        }
        if (gfResourceSetProvider == null) {
            gfResourceSetProvider = new IResourceSetProvider(){

                @Override
                public ResourceSet getResourceSet(IResource resource) {
                    return new ResourceSetImpl();
                }
            };
        }
        return gfResourceSetProvider;
    }

    static class EditModelCache {
        protected Map<ResourceSet, EditModel> resourceSetToEditModel = new HashMap<ResourceSet, EditModel>();
        protected Map<IResource, ResourceSet> fileToResourceSet = new HashMap<IResource, ResourceSet>();

        EditModelCache() {
        }

        public EditModel getEditModel(IResource primaryFile, Factory factory) {
            ResourceSet resourceSet = this.getResourceSet(primaryFile);
            return this.getEditModel(resourceSet, primaryFile, factory);
        }

        private EditModel getEditModel(ResourceSet resourceSet, IResource primaryFile, Factory factory) {
            EditModel editModel = this.resourceSetToEditModel.get(resourceSet);
            if (editModel != null) {
                ++editModel.referenceCount;
                return editModel;
            }
            editModel = factory.createEditModel(resourceSet, primaryFile);
            ++editModel.referenceCount;
            this.resourceSetToEditModel.put(resourceSet, editModel);
            final EditModel finalEditModel = editModel;
            resourceSet.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    Resource r = (Resource)msg.getNewValue();
                    finalEditModel.getResourceInfoForLoadedResource(r);
                }
            });
            return editModel;
        }

        private ResourceSet getResourceSet(IResource primaryFile) {
            ResourceSet resourceSet = this.fileToResourceSet.get(primaryFile);
            if (resourceSet != null) {
                return resourceSet;
            }
            resourceSet = new BPELResourceSetImpl();
            this.fileToResourceSet.put(primaryFile, resourceSet);
            return resourceSet;
        }

        public void remove(EditModel editModel) {
            this.resourceSetToEditModel.remove(editModel.resourceSet);
            this.fileToResourceSet.remove(editModel.primaryFile);
        }

        void updatePrimaryFile(IResource oldFile, IResource newFile) {
            ResourceSet rs = this.fileToResourceSet.get(oldFile);
            this.fileToResourceSet.remove(oldFile);
            this.fileToResourceSet.put(newFile, rs);
        }
    }

    public static class Factory {
        protected EditModel createEditModel(ResourceSet resourceSet, IResource primaryFile) {
            return new EditModel(resourceSet, primaryFile);
        }
    }
}

