/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.simpleapi.IAction;
import org.eclipse.birt.report.model.api.simpleapi.IImage;
import org.eclipse.birt.report.model.simpleapi.ActionImpl;
import org.eclipse.birt.report.model.simpleapi.ReportItem;

public class Image
extends ReportItem
implements IImage {
    public Image(ImageHandle image) {
        super(image);
    }

    @Override
    public double getScale() {
        return ((ImageHandle)this.handle).getScale();
    }

    @Override
    public String getSize() {
        return ((ImageHandle)this.handle).getSize();
    }

    @Override
    @Deprecated
    public String getAltText() {
        ExpressionHandle expr = ((ImageHandle)this.handle).getAltTextExpression();
        if (expr != null) {
            return expr.getStringExpression();
        }
        return null;
    }

    @Override
    @Deprecated
    public void setAltText(String altText) throws SemanticException {
        this.setProperty("altText", new Expression(altText, "constant"));
    }

    @Override
    public String getAltTextKey() {
        return ((ImageHandle)this.handle).getAltTextKey();
    }

    @Override
    public void setAltTextKey(String altTextKey) throws SemanticException {
        this.setProperty("altTextID", altTextKey);
    }

    @Override
    public String getSource() {
        return ((ImageHandle)this.handle).getSource();
    }

    @Override
    public void setSource(String source) throws SemanticException {
        this.setProperty("source", source);
    }

    @Override
    public String getURI() {
        return ((ImageHandle)this.handle).getURI();
    }

    @Override
    public String getTypeExpression() {
        return ((ImageHandle)this.handle).getTypeExpression();
    }

    @Override
    public String getValueExpression() {
        return ((ImageHandle)this.handle).getValueExpression();
    }

    @Override
    public String getImageName() {
        return ((ImageHandle)this.handle).getImageName();
    }

    @Override
    public void setImageName(String name) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setImageName(name);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void setURI(String uri) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setURI(uri);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void setScale(double scale) throws SemanticException {
        this.setProperty("scale", scale);
    }

    @Override
    public void setSize(String size) throws SemanticException {
        this.setProperty("size", size);
    }

    @Override
    public void setTypeExpression(String value) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setTypeExpression(value);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public void setValueExpression(String value) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setValueExpression(value);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public String getHelpText() {
        return ((ImageHandle)this.handle).getHelpText();
    }

    @Override
    public void setHelpText(String helpText) throws SemanticException {
        this.setProperty("helpText", helpText);
    }

    @Override
    public String getHelpTextKey() {
        return ((ImageHandle)this.handle).getHelpTextKey();
    }

    @Override
    public void setHelpTextKey(String helpTextKey) throws SemanticException {
        this.setProperty("helpTextID", helpTextKey);
    }

    @Override
    public IAction getAction() {
        return new ActionImpl(((ImageHandle)this.handle).getActionHandle(), (ImageHandle)this.handle);
    }

    @Override
    public void setFile(String file) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setFile(file);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public String getFile() {
        return ((ImageHandle)this.handle).getFile();
    }

    @Override
    public void setURL(String url) throws SemanticException {
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setURL(url);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    @Override
    public String getURL() {
        return ((ImageHandle)this.handle).getURL();
    }

    @Override
    public void addAction(IAction action) throws SemanticException {
        if (action == null) {
            return;
        }
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ImageHandle)this.handle).setAction((Action)action.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }
}

