/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.DimensionLevel;
import org.eclipse.birt.report.designer.data.ui.util.CubeValueSelector;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.widget.PopupSelectionList;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExpressionValueCellEditor
extends CellEditor {
    protected static final Logger logger = Logger.getLogger(ExpressionValueCellEditor.class.getName());
    private static String[] actions = new String[]{Messages.getString("ExpressionValueCellEditor.selectValueAction")};
    private transient ParamBindingHandle[] bindingParams = null;
    private MemberValueHandle memberValue;
    private transient Text expressionText;
    private transient Button btnPopup;
    private transient ExtendedItemHandle currentItem = null;
    private transient String[] popupItems = null;
    private transient boolean refreshItems = true;
    private List referencedLevelList;
    private static String[] EMPTY_ARRAY = new String[0];

    public void setMemberValue(MemberValueHandle memberValue) {
        this.memberValue = memberValue;
    }

    public ExpressionValueCellEditor() {
    }

    public ExpressionValueCellEditor(Composite parent) {
        super(parent);
    }

    public ExpressionValueCellEditor(Composite parent, boolean useDataSetFilter) {
        super(parent);
    }

    public ExpressionValueCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        Composite editorComposite = new Composite(parent, this.getStyle());
        editorComposite.setLayout((Layout)new ExpressionCellLayout());
        this.expressionText = new Text(editorComposite, 0);
        this.expressionText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExpressionValueCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.expressionText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.expressionText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.expressionText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExpressionValueCellEditor.this.focusLost();
            }
        });
        this.btnPopup = new Button(editorComposite, 1028);
        this.btnPopup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionValueCellEditor.this.refreshList();
                Rectangle textBounds = ExpressionValueCellEditor.this.expressionText.getBounds();
                Point pt = ExpressionValueCellEditor.this.expressionText.toDisplay(textBounds.x, textBounds.y);
                Rectangle rect = new Rectangle(pt.x, pt.y, ((ExpressionValueCellEditor)ExpressionValueCellEditor.this).expressionText.getParent().getBounds().width, textBounds.height);
                PopupSelectionList popup = new PopupSelectionList(ExpressionValueCellEditor.this.expressionText.getParent().getShell());
                popup.setItems(ExpressionValueCellEditor.this.popupItems);
                String value = popup.open(rect);
                int selectionIndex = popup.getSelectionIndex();
                if (value != null) {
                    String newValue = null;
                    if (value.equals(actions[0])) {
                        List valueList = ExpressionValueCellEditor.this.getSelectMemberValueList();
                        if (valueList == null || valueList.size() == 0) {
                            MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
                        } else {
                            SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                            dialog.setSelectedValueList((Collection)valueList);
                            if (dialog.open() == 0) {
                                newValue = DEUtil.removeQuote((String)dialog.getSelectedExprValue());
                            }
                        }
                    } else if (selectionIndex > 3) {
                        newValue = ExpressionUtil.createJSParameterValueExpression((String)value);
                    }
                    if (newValue != null) {
                        ExpressionValueCellEditor.this.setValue(newValue);
                    }
                    ExpressionValueCellEditor.this.expressionText.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setValueValid(true);
        return editorComposite;
    }

    protected void focusLost() {
        if (this.btnPopup != null && !this.btnPopup.isFocusControl() && Display.getCurrent().getCursorControl() != this.btnPopup) {
            super.focusLost();
        }
    }

    protected Object doGetValue() {
        if (this.expressionText != null) {
            return this.expressionText.getText();
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.expressionText != null && this.expressionText.isVisible()) {
            this.expressionText.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        if (value != null && this.expressionText != null) {
            this.expressionText.setText(value.toString());
        }
    }

    public ParamBindingHandle[] getBindingParams() {
        return this.bindingParams;
    }

    public void setBindingParams(ParamBindingHandle[] bindingParams) {
        this.bindingParams = bindingParams;
    }

    public void setBindingName(String bindingName) {
    }

    public void setReportElement(ExtendedItemHandle reportItem) {
        this.currentItem = reportItem;
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            int n = 0;
            while (n < actions.length) {
                finalItems.add(actions[n]);
                ++n;
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    public void activate() {
        this.refreshItems = true;
        super.activate();
    }

    public void setExpressionProvider(IExpressionProvider provider) {
    }

    public void setReferencedLevelList(List referencedLevelList) {
        this.referencedLevelList = referencedLevelList;
    }

    private CubeHandle getCubeHandle() {
        CrosstabReportItemHandle crosstab = null;
        if (this.currentItem != null) {
            try {
                crosstab = (CrosstabReportItemHandle)this.currentItem.getReportItem();
                return crosstab.getCube();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    private List getExistValueList() {
        DesignElementHandle container;
        ArrayList<MemberValueHandle> valueList = new ArrayList<MemberValueHandle>();
        MemberValueHandle tmpMemberValue = this.memberValue;
        while ((container = tmpMemberValue.getContainer()) != null && container instanceof MemberValueHandle) {
            tmpMemberValue = (MemberValueHandle)container;
            valueList.add(0, tmpMemberValue);
        }
        return valueList;
    }

    private List getSelectMemberValueList() {
        CubeHandle cube = this.getCubeHandle();
        ArrayList<String> valueList = new ArrayList<String>();
        List extValueList = this.getExistValueList();
        int i = 0;
        while (i < extValueList.size()) {
            MemberValueHandle tmpMemberValue = (MemberValueHandle)extValueList.get(i);
            String value = tmpMemberValue.getValue();
            if (value == null || value.length() == 0) {
                return new ArrayList();
            }
            valueList.add(value);
            ++i;
        }
        Object[] values = valueList.toArray(new Object[valueList.size()]);
        if (values.length == 0) {
            values = null;
        }
        DimensionLevel[] levelDens = null;
        if (values != null) {
            levelDens = new DimensionLevel[values.length];
            int i2 = 0;
            while (i2 < values.length) {
                Object obj = this.referencedLevelList.get(i2);
                if (obj == null || !(obj instanceof DimensionLevel)) {
                    return new ArrayList();
                }
                levelDens[i2] = (DimensionLevel)obj;
                ++i2;
            }
        } else {
            levelDens = null;
        }
        String targetLevel = null;
        int index = 0;
        if (values != null && values.length > 0 && values.length + 1 <= this.referencedLevelList.size()) {
            index = values.length;
        }
        DimensionLevel levelDefn = (DimensionLevel)this.referencedLevelList.get(index);
        String levelName = levelDefn.getLevelName();
        String dimensionName = levelDefn.getDimensionName();
        targetLevel = ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)levelName);
        if (cube == null || targetLevel == null || targetLevel.length() == 0) {
            return new ArrayList();
        }
        Iterator iter = null;
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            DataService.getInstance().registerSession(cube, session);
            iter = CubeValueSelector.getMemberValueIterator((DataRequestSession)session, (CubeHandle)cube, (String)targetLevel, (DimensionLevel[])levelDens, (Object[])values);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        ArrayList retList = new ArrayList();
        int count = 0;
        int MAX_COUNT = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault(), UIUtil.getCurrentProject()).getInt("Filter.Limit");
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || retList.indexOf(obj) >= 0) continue;
            retList.add(obj);
            if (++count >= MAX_COUNT) break;
        }
        if (session != null) {
            session.shutdown();
        }
        return retList;
    }

    private class ExpressionCellLayout
    extends Layout {
        private ExpressionCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ExpressionValueCellEditor.this.btnPopup.computeSize(-1, -1, force);
            ExpressionValueCellEditor.this.expressionText.setBounds(0, 0, bounds.width - size.x, bounds.height);
            ExpressionValueCellEditor.this.btnPopup.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ExpressionValueCellEditor.this.expressionText.computeSize(-1, -1, force);
            Point buttonSize = ExpressionValueCellEditor.this.btnPopup.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

