/*************************************************************************************
 * Copyright (c) 2004 Actuate Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Actuate Corporation - Initial implementation.
 ************************************************************************************/

package org.eclipse.birt.report.designer.internal.ui.editors.xml;

import org.eclipse.jface.text.*;
import org.eclipse.jface.text.rules.*;

public class XMLTagScanner extends RuleBasedScanner
{

	public XMLTagScanner( ColorManager manager )
	{
		IToken string = new Token( new TextAttribute( manager.getColor( IXMLColorConstants.STRING ) ) );

		IRule[] rules = new IRule[3];

		// Add rule for double quotes
		rules[0] = new SingleLineRule( "\"", "\"", string, '\\' ); //$NON-NLS-1$ //$NON-NLS-2$
		// Add a rule for single quotes
		rules[1] = new SingleLineRule( "'", "'", string, '\\' ); //$NON-NLS-1$ //$NON-NLS-2$
		// Add generic whitespace rule.
		rules[2] = new WhitespaceRule( new XMLWhitespaceDetector( ) );

		setRules( rules );
	}
}
