/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.Ext2Block;
import org.eclipse.birt.core.archive.compound.v3.Ext2Constants;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.util.IOUtil;

class FatBlock
extends Ext2Block
implements Ext2Constants {
    static final int BLOCK_PER_FAT_BLOCK = 1024;
    boolean dirty;
    int[] blocks = new int[1024];

    FatBlock(Ext2FileSystem fs, int blockId) {
        super(fs, blockId);
        int i = 0;
        while (i < 1024) {
            this.blocks[i] = -1;
            ++i;
        }
    }

    @Override
    public int getBlockId() {
        return this.blockId;
    }

    public void setBlock(int index, int blockId) throws IOException {
        assert (index < 1024);
        this.dirty = true;
        this.blocks[index] = blockId;
    }

    public int getBlock(int index) throws IOException {
        assert (index < 1024);
        return this.blocks[index];
    }

    @Override
    public void flush() throws IOException {
        if (this.blockId == -1) {
            throw new IllegalStateException("Must assign block id before flush");
        }
        if (this.dirty) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            int i = 0;
            while (i < 1024) {
                IOUtil.writeInt(out, this.blocks[i]);
                ++i;
            }
            this.fs.writeBlock(this.blockId, out.toByteArray(), 0, 4096);
        }
    }

    @Override
    public void refresh() throws IOException {
        if (this.blockId == -1) {
            throw new IllegalStateException("Must assign block id before flush");
        }
        byte[] buffer = new byte[4096];
        this.fs.readBlock(this.blockId, buffer, 0, 4096);
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        int i = 0;
        while (i < 1024) {
            this.blocks[i] = IOUtil.readInt(in);
            ++i;
        }
    }
}

