/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.traceability.engine;

import java.util.NoSuchElementException;

public final class TraceabilityTokenizer {
    private final String source;
    private final String delims;
    private int lastOffset;
    private int nextOffset;
    private boolean soughtNext;

    public TraceabilityTokenizer(String source, String delims) {
        this.source = source;
        this.delims = delims;
    }

    public int countTokens() {
        int tokenOffset = 0;
        int tokenCount = 0;
        do {
            tokenOffset = this.skipDelimiters(tokenOffset);
            tokenOffset = this.scanToken(tokenOffset);
            ++tokenCount;
        } while (this.skipDelimiters(tokenOffset) < this.source.length());
        return tokenCount;
    }

    public int getLastOffset() {
        return this.lastOffset;
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    public boolean hasMoreTokens() {
        if (this.soughtNext) {
            return true;
        }
        boolean result = true;
        if (this.skipDelimiters(this.nextOffset) == this.source.length()) {
            result = false;
        } else {
            this.lastOffset = this.skipDelimiters(this.nextOffset);
            if (this.lastOffset == this.source.length()) {
                result = false;
            }
            this.nextOffset = this.scanToken(this.lastOffset);
            this.soughtNext = true;
        }
        return result;
    }

    public String nextToken() throws NoSuchElementException {
        if (!this.soughtNext) {
            this.lastOffset = this.skipDelimiters(this.nextOffset);
            if (this.lastOffset == this.source.length()) {
                throw new NoSuchElementException();
            }
            this.nextOffset = this.scanToken(this.lastOffset);
        } else {
            this.soughtNext = false;
        }
        return new String(this.source.substring(this.lastOffset, this.nextOffset));
    }

    private int scanToken(int start) {
        int position = start;
        while (position < this.source.length()) {
            char c = this.source.charAt(position);
            if (this.delims.indexOf(c) >= 0) break;
            ++position;
        }
        return position;
    }

    private int skipDelimiters(int start) {
        int position = start;
        while (position < this.source.length()) {
            char c = this.source.charAt(position);
            if (this.delims.indexOf(c) < 0) break;
            ++position;
        }
        return position;
    }
}

