/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Incubating;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    VERSION_1_1,
    VERSION_1_2,
    VERSION_1_3,
    VERSION_1_4,
    VERSION_1_5,
    VERSION_1_6,
    VERSION_1_7,
    VERSION_1_8,
    VERSION_1_9,
    VERSION_1_10,
    VERSION_11,
    VERSION_HIGHER;

    private static final int FIRST_MAJOR_VERSION_ORDINAL = 10;
    private static JavaVersion currentJavaVersion;
    private final String versionName = this.ordinal() >= 10 ? this.getMajorVersion() : "1." + this.getMajorVersion();

    public static JavaVersion toVersion(Object value) throws IllegalArgumentException {
        int firstNonVersionCharIndex;
        String[] versionStrings;
        if (value == null) {
            return null;
        }
        if (value instanceof JavaVersion) {
            return (JavaVersion)((Object)value);
        }
        String name = value.toString();
        List<Integer> versions = JavaVersion.convertToNumber(name, versionStrings = name.substring(0, firstNonVersionCharIndex = JavaVersion.findFirstNonVersionCharIndex(name)).split("\\."));
        if (JavaVersion.isLegacyVersion(versions)) {
            JavaVersion.assertTrue(name, versions.get(1) > 0);
            return JavaVersion.getVersionForMajor(versions.get(1));
        }
        return JavaVersion.getVersionForMajor(versions.get(0));
    }

    public static JavaVersion current() {
        if (currentJavaVersion == null) {
            currentJavaVersion = JavaVersion.toVersion(System.getProperty("java.version"));
        }
        return currentJavaVersion;
    }

    @VisibleForTesting
    static void resetCurrent() {
        currentJavaVersion = null;
    }

    public static JavaVersion forClassVersion(int classVersion) {
        return JavaVersion.getVersionForMajor(classVersion - 44);
    }

    public static JavaVersion forClass(byte[] classData) {
        if (classData.length < 8) {
            throw new IllegalArgumentException("Invalid class format. Should contain at least 8 bytes");
        }
        return JavaVersion.forClassVersion(classData[7] & 0xFF);
    }

    public boolean isJava5() {
        return this == VERSION_1_5;
    }

    public boolean isJava6() {
        return this == VERSION_1_6;
    }

    public boolean isJava7() {
        return this == VERSION_1_7;
    }

    public boolean isJava8() {
        return this == VERSION_1_8;
    }

    public boolean isJava9() {
        return this == VERSION_1_9;
    }

    public boolean isJava10() {
        return this == VERSION_1_10;
    }

    @Incubating
    public boolean isJava11() {
        return this == VERSION_11;
    }

    public boolean isJava5Compatible() {
        return this.compareTo(VERSION_1_5) >= 0;
    }

    public boolean isJava6Compatible() {
        return this.compareTo(VERSION_1_6) >= 0;
    }

    public boolean isJava7Compatible() {
        return this.compareTo(VERSION_1_7) >= 0;
    }

    public boolean isJava8Compatible() {
        return this.compareTo(VERSION_1_8) >= 0;
    }

    public boolean isJava9Compatible() {
        return this.compareTo(VERSION_1_9) >= 0;
    }

    public boolean isJava10Compatible() {
        return this.compareTo(VERSION_1_10) >= 0;
    }

    @Incubating
    public boolean isJava11Compatible() {
        return this.compareTo(VERSION_11) >= 0;
    }

    public String toString() {
        return this.versionName;
    }

    private String getName() {
        return this.versionName;
    }

    public String getMajorVersion() {
        return String.valueOf(this.ordinal() + 1);
    }

    private static JavaVersion getVersionForMajor(int major) {
        return major >= JavaVersion.values().length ? VERSION_HIGHER : JavaVersion.values()[major - 1];
    }

    private static void assertTrue(String value, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("Could not determine java version from '" + value + "'.");
        }
    }

    private static boolean isLegacyVersion(List<Integer> versions) {
        return 1 == versions.get(0) && versions.size() > 1;
    }

    private static List<Integer> convertToNumber(String value, String[] versionStrs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : versionStrs) {
            JavaVersion.assertTrue(value, !JavaVersion.isNumberStartingWithZero(s));
            try {
                result.add(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                JavaVersion.assertTrue(value, false);
            }
        }
        JavaVersion.assertTrue(value, !result.isEmpty() && (Integer)result.get(0) > 0);
        return result;
    }

    private static boolean isNumberStartingWithZero(String number) {
        return number.length() > 1 && number.startsWith("0");
    }

    private static int findFirstNonVersionCharIndex(String s) {
        JavaVersion.assertTrue(s, s.length() != 0);
        for (int i = 0; i < s.length(); ++i) {
            if (JavaVersion.isDigitOrPeriod(s.charAt(i))) continue;
            JavaVersion.assertTrue(s, i != 0);
            return i;
        }
        return s.length();
    }

    private static boolean isDigitOrPeriod(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }
}

