/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.migrator;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.viatra.query.tooling.ui.migrator.FileStringReplacer;
import org.eclipse.viatra.query.tooling.ui.migrator.JavaProjectMigratorData;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;

public class JavaProjectMigrator
extends JavaProjectMigratorData {
    private final IJavaProject javaProject;

    public JavaProjectMigrator(IProject project) {
        this.javaProject = JavaCore.create((IProject)project);
    }

    public JavaProjectMigrator(IJavaProject project) {
        this.javaProject = project;
    }

    public void migrate(IProgressMonitor monitor) {
        try {
            IPackageFragmentRoot[] _packageFragmentRoots;
            IPackageFragment[] _packageFragments;
            final SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            LinkedList list = CollectionLiterals.newLinkedList((Object[])new ICompilationUnit[0]);
            IPackageFragment[] iPackageFragmentArray = _packageFragments = this.javaProject.getPackageFragments();
            int n = _packageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _equals;
                IPackageFragment p = iPackageFragmentArray[n2];
                int _kind = p.getKind();
                boolean bl = _equals = _kind == 1;
                if (_equals) {
                    CollectionExtensions.addAll((Collection)list, (Object[])p.getCompilationUnits());
                }
                ++n2;
            }
            int _size = list.size();
            int _multiply = _size * 2;
            int _plus = _multiply + 1;
            m.beginTask("Migrating project", _plus);
            IProject project = this.javaProject.getProject();
            boolean _isOpenPDEProject = ProjectGenerationHelper.isOpenPDEProject((IProject)project);
            if (_isOpenPDEProject) {
                ProjectGenerationHelper.replaceBundleDependencies((IProject)project, JavaProjectMigratorData.bundleRenames, JavaProjectMigratorData.bundleVersions, (IProgressMonitor)m.newChild(1));
                ProjectGenerationHelper.ensureBundleDependenciesAndPackageImports((IProject)project, (List)ProjectGenerationHelper.DEFAULT_VIATRA_BUNDLE_REQUIREMENTS, (List)ProjectGenerationHelper.DEFAULT_VIATRA_IMPORT_PACKAGES, (IProgressMonitor)m.newChild(1));
            }
            final ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            for (final ICompilationUnit unit : list) {
                Display _default = Display.getDefault();
                _default.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ASTNode ast = JavaProjectMigrator.this.parse(unit, (IProgressMonitor)m.newChild(1));
                            ASTRewrite rewrite = JavaProjectMigrator.this.collectChanges(ast);
                            m.worked(1);
                            TextEdit textEdit = rewrite.rewriteAST();
                            IPath path = unit.getPath();
                            try {
                                bufferManager.connect(path, LocationKind.IFILE, null);
                                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                                IDocument document = textFileBuffer.getDocument();
                                textEdit.apply(document);
                                textFileBuffer.commit(null, false);
                            }
                            finally {
                                bufferManager.disconnect(path, LocationKind.IFILE, null);
                                m.worked(1);
                            }
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                });
            }
            LinkedList xtendlist = CollectionLiterals.newLinkedList((Object[])new IFile[0]);
            IPackageFragmentRoot[] iPackageFragmentRootArray = _packageFragmentRoots = this.javaProject.getPackageFragmentRoots();
            int n3 = _packageFragmentRoots.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean _equals_1;
                IPackageFragmentRoot p_1 = iPackageFragmentRootArray[n4];
                int _kind_1 = p_1.getKind();
                boolean bl = _equals_1 = _kind_1 == 1;
                if (_equals_1) {
                    IResourceVisitor _function = it -> {
                        if (it instanceof IFile && "xtend".equalsIgnoreCase(it.getFileExtension())) {
                            xtendlist.add((IFile)it);
                        }
                        return it instanceof IContainer;
                    };
                    ResourcesPlugin.getWorkspace().getRoot().getFolder(p_1.getPath()).accept(_function);
                }
                ++n4;
            }
            for (IFile file : xtendlist) {
                this.updateXTend(file);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void updateXTend(IFile xtendFile) {
        try {
            FileStringReplacer replacer = new FileStringReplacer(xtendFile);
            Set<Map.Entry<String, String>> _entrySet = JavaProjectMigratorData.qualifiedNameRenames.entrySet();
            for (Map.Entry<String, String> entry : _entrySet) {
                String _value;
                String _plus_1;
                boolean _endsWith = entry.getKey().endsWith(".");
                if (_endsWith) {
                    replacer.replacePattern(entry.getKey(), entry.getValue());
                    continue;
                }
                String _key = entry.getKey();
                String _plus = "import " + _key;
                boolean _replacePattern = replacer.replacePattern(_plus, _plus_1 = "import " + (_value = entry.getValue()));
                if (_replacePattern) {
                    replacer.replacePattern(this.getLastSegment(entry.getKey()), this.getLastSegment(entry.getValue()));
                    continue;
                }
                replacer.replacePattern(entry.getKey(), entry.getValue());
            }
            replacer.save();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ASTNode parse(ICompilationUnit unit, IProgressMonitor monitor) {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(8);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        return parser.createAST(monitor);
    }

    public String replaceName(String oldValue, Map.Entry<String, String> entry) {
        return oldValue.replace(entry.getKey(), entry.getValue());
    }

    public String getLastSegment(String fqn) {
        boolean _endsWith = fqn.endsWith(".");
        if (_endsWith) {
            return "";
        }
        int i = fqn.lastIndexOf(".");
        if (i >= 0) {
            return fqn.substring(i + 1);
        }
        return fqn;
    }

    public void createChange(ASTRewrite rewrite, ImportDeclaration importDeclaration, Map<String, String> typeRenames) {
        String fullyQualifiedName = importDeclaration.getName().getFullyQualifiedName();
        Set _entrySet = qualifiedNameRenames.entrySet();
        for (Map.Entry<String, String> entry : _entrySet) {
            String tn_new;
            boolean _notEquals;
            boolean _startsWith = fullyQualifiedName.startsWith((String)entry.getKey());
            if (!_startsWith) continue;
            String newName = this.replaceName(fullyQualifiedName, entry);
            String tn_old = this.getLastSegment(fullyQualifiedName);
            boolean bl = _notEquals = !Objects.equal((Object)tn_old, (Object)(tn_new = this.getLastSegment(newName)));
            if (_notEquals) {
                typeRenames.put(tn_old, tn_new);
            }
            rewrite.set((ASTNode)importDeclaration, (StructuralPropertyDescriptor)ImportDeclaration.NAME_PROPERTY, (Object)importDeclaration.getAST().newName(newName), null);
            return;
        }
    }

    public void createChange(ASTRewrite rewrite, SimpleType type, Map<String, String> typeRenames) {
        String n;
        boolean _containsKey;
        Name name = type.getName();
        if (name instanceof QualifiedName) {
            String fullyQualifiedName = ((QualifiedName)name).getFullyQualifiedName();
            Set _entrySet = qualifiedNameRenames.entrySet();
            for (Map.Entry<String, String> entry : _entrySet) {
                boolean _startsWith = fullyQualifiedName.startsWith((String)entry.getKey());
                if (!_startsWith) continue;
                rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)ImportDeclaration.NAME_PROPERTY, (Object)type.getAST().newName(this.replaceName(fullyQualifiedName, entry)), null);
                return;
            }
        }
        if (name instanceof SimpleName && (_containsKey = typeRenames.containsKey(n = ((SimpleName)name).getFullyQualifiedName()))) {
            rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)SimpleType.NAME_PROPERTY, (Object)type.getAST().newName(typeRenames.get(n)), null);
        }
    }

    public ASTRewrite collectChanges(ASTNode node) {
        final ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        final HashMap typeRenames = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        node.accept(new ASTVisitor(){

            public boolean visit(ImportDeclaration node) {
                boolean _xblockexpression = false;
                JavaProjectMigrator.this.createChange(rewrite, node, (Map<String, String>)typeRenames);
                _xblockexpression = super.visit(node);
                return _xblockexpression;
            }

            public boolean visit(SimpleType node) {
                boolean _xblockexpression = false;
                JavaProjectMigrator.this.createChange(rewrite, node, (Map<String, String>)typeRenames);
                _xblockexpression = super.visit(node);
                return _xblockexpression;
            }
        });
        return rewrite;
    }
}

