/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.ui.AdaptableResourceList;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class SyncInfoSetDetailsDialog
extends DetailsDialog {
    private static final int WIDTH_HINT = 350;
    private static final int SELECTION_HEIGHT_HINT = 100;
    private CheckboxTableViewer listViewer;
    private SyncInfoSet syncSet;
    private Object[] selectedResources;

    public SyncInfoSetDetailsDialog(Shell parentShell, String dialogTitle, SyncInfoSet syncSet) {
        super(parentShell, dialogTitle);
        this.syncSet = syncSet;
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.addResourcesArea(composite);
        return composite;
    }

    private void addResourcesArea(Composite composite) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 350;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getFullPath().toString();
                }
                return input;
            }
        });
        this.listViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.setViewerInput();
        this.listViewer.addSelectionChangedListener(event -> {
            this.selectedResources = this.listViewer.getCheckedElements();
            Object[] objectArray = this.selectedResources;
        });
        this.addSelectionButtons(composite);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, CVSUIMessages.ReleaseCommentDialog_selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncInfoSetDetailsDialog.this.listViewer.setAllChecked(true);
                SyncInfoSetDetailsDialog.this.selectedResources = null;
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, CVSUIMessages.ReleaseCommentDialog_deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyncInfoSetDetailsDialog.this.listViewer.setAllChecked(false);
                SyncInfoSetDetailsDialog.this.selectedResources = new Object[0];
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void setViewerInput() {
        if (this.listViewer == null || this.listViewer.getControl().isDisposed()) {
            return;
        }
        this.listViewer.setInput((Object)new AdaptableResourceList(this.getAllResources()));
        if (this.selectedResources == null) {
            this.listViewer.setAllChecked(true);
        } else {
            this.listViewer.setCheckedElements(this.selectedResources);
        }
    }

    protected IResource[] getAllResources() {
        return this.syncSet.getResources();
    }

    protected void updateEnablements() {
    }

    public SyncInfoSet getSyncSet() {
        return this.syncSet;
    }

    protected void buttonPressed(int id) {
        if (id == 0) {
            this.filterSyncSet();
        }
        super.buttonPressed(id);
    }

    protected void filterSyncSet() {
        if (this.selectedResources != null) {
            this.getSyncSet().selectNodes(new FastSyncInfoFilter(){

                public boolean select(SyncInfo info) {
                    IResource local = info.getLocal();
                    int i = 0;
                    while (i < SyncInfoSetDetailsDialog.this.selectedResources.length) {
                        if (local.equals(SyncInfoSetDetailsDialog.this.selectedResources[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            });
        }
    }
}

