/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.ui.controls.activator.UIPlugin;
import org.eclipse.tcf.te.ui.controls.validator.VerifyListener;

public class RegexVerifyListener
extends VerifyListener {
    private String regex;

    public RegexVerifyListener(int attributes, String regex) {
        super(attributes);
        this.setRegularExpression(regex);
    }

    protected String getFullText(VerifyEvent e) {
        StringBuffer fulltext = new StringBuffer();
        if (e.widget instanceof Text) {
            Text text = (Text)e.widget;
            fulltext.append(text.getText());
        } else if (e.widget instanceof Combo) {
            Combo combo = (Combo)e.widget;
            fulltext.append(combo.getText());
        }
        try {
            if (e.end > e.start) {
                fulltext.replace(e.start, e.end, e.text);
            } else if (e.end >= 0) {
                fulltext.insert(e.end, e.text);
            }
        }
        catch (StringIndexOutOfBoundsException exc) {
            Status status = new Status(4, UIPlugin.getUniqueIdentifier(), String.valueOf(exc.getLocalizedMessage()) + ", VerifyEvent(" + e.toString() + ")", (Throwable)exc);
            UIPlugin.getDefault().getLog().log((IStatus)status);
        }
        return fulltext.toString();
    }

    public void verifyText(VerifyEvent e) {
        e.doit = this.getFullText(e).matches(this.regex);
    }

    protected String getRegularExpression() {
        return this.regex;
    }

    protected void setRegularExpression(String regex) {
        this.regex = regex != null && regex.length() > 0 ? regex : ".*";
    }
}

