/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.interpreter.context;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.common.tools.api.interpreter.DefaultInterpreterContextFactory;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ext.base.Option;

public final class SiriusInterpreterContextFactory {
    private SiriusInterpreterContextFactory() {
    }

    public static IInterpreterContext createInterpreterContext(EObject element, EStructuralFeature feature) {
        LinkedHashSet<String> targetDomainClasses = new LinkedHashSet<String>();
        Collection<Object> avalaiblePackages = new LinkedHashSet();
        Collection<Object> dependencies = new LinkedHashSet();
        Map<Object, Object> variables = new LinkedHashMap();
        boolean requiresTargetType = true;
        IInterpretedExpressionQuery query = DialectManager.INSTANCE.createInterpretedExpressionQuery(element, feature);
        Option<Collection<String>> targetDomainClassesOption = query.getTargetDomainClasses();
        if (!targetDomainClassesOption.some()) {
            requiresTargetType = false;
        } else {
            for (String domainClass : (Collection)targetDomainClassesOption.get()) {
                targetDomainClasses.add(domainClass);
            }
        }
        if (!targetDomainClassesOption.some() || !((Collection)targetDomainClassesOption.get()).isEmpty()) {
            avalaiblePackages = query.getPackagesToImport();
            variables = query.getAvailableVariables();
            dependencies = query.getDependencies();
        }
        IInterpreterContext context = DefaultInterpreterContextFactory.createInterpreterContext((EObject)element, (boolean)requiresTargetType, (EStructuralFeature)feature, (VariableType)VariableType.fromStrings(targetDomainClasses), avalaiblePackages, variables, dependencies);
        return context;
    }
}

