/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.internal.graphicalcomponents;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ui.editor.Messages;
import org.eclipse.sirius.ui.editor.SessionEditorPlugin;
import org.eclipse.sirius.ui.tools.api.views.LockDecorationUpdater;
import org.eclipse.sirius.ui.tools.api.views.common.item.ProjectDependenciesItem;
import org.eclipse.sirius.ui.tools.api.wizards.CreateEMFModelWizard;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.AddModelDependencyAction;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.RemoveSemanticResourceAction;
import org.eclipse.sirius.ui.tools.internal.views.common.item.NoDynamicProjectDependencies;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointsFolderItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.ManageSessionActionProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonContentProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.filter.FilteredCommonTree;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.sorter.RepresentationInSemanticSorter;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.DeleteActionHandler;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.RenameActionHandler;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;

public class GraphicalSemanticModelsHandler
implements SessionListener,
SessionManagerListener {
    public static final String SEMANTIC_MODELS_VIEWER_ID = "org.eclipse.sirius.ui.editor.internal.graphicalcomponents.semanticModelsViewer";
    protected Collection<IAction> createSiblingActions;
    protected Collection<IAction> createChildActions;
    protected Session session;
    private FormToolkit toolkit;
    private SiriusCommonContentProvider siriusCommonContentModelProvider;
    private Button removeSemanticModelDependencyButton;
    private CommonViewer treeViewer;
    private MenuManager menuManager;
    private ManageSessionActionProvider manageSessionActionProvider;
    private IActionBars actionBars;
    private ISelectionProvider selectionProvider;
    private ResourceSetListenerChangeListener resourceSetListenerChangeListener;
    private EcoreActionsHandler ecoreActionsHandler;
    private CommandStackListener commandStackListener;
    private IWorkbenchSite site;
    private LockDecorationUpdater lockDecorationUpdater;

    public GraphicalSemanticModelsHandler(Session theSession, FormToolkit toolkit, IActionBars theActionBars, ISelectionProvider theSelectionProvider, IWorkbenchSite theSite) {
        this.session = theSession;
        this.toolkit = toolkit;
        this.actionBars = theActionBars;
        this.selectionProvider = theSelectionProvider;
        this.site = theSite;
    }

    public CommonViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void createControl(Composite parentComposite) {
        this.createModelExplorerNavigator(parentComposite);
        this.createModelExplorerButton(parentComposite, (TreeViewer)this.treeViewer);
        this.session.addListener((SessionListener)this);
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
        this.siriusCommonContentModelProvider.addRefreshViewerTrigger(this.session);
        this.treeViewer.getTree().getHorizontalBar().setSelection(0);
        this.resourceSetListenerChangeListener = new ResourceSetListenerChangeListener();
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.resourceSetListenerChangeListener);
        this.lockDecorationUpdater = new LockDecorationUpdater();
        this.lockDecorationUpdater.register((TreeViewer)this.treeViewer);
    }

    private void createModelExplorerButton(Composite parent, TreeViewer theTreeViewer) {
        Composite subComposite = this.toolkit.createComposite(parent, 0);
        subComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        subComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite buttonsComposite = this.toolkit.createComposite(subComposite, 0);
        FillLayout buttonsLayout = new FillLayout(1);
        buttonsLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        Button newButton = this.addButton(buttonsComposite, Messages.UI_SessionEditor_new_semantic_model_action_label, () -> this.createAndRegisterNewSemanticModel());
        newButton.setToolTipText(Messages.GraphicalSemanticModelsHandler_newModelButton_tooltip);
        Button addButton = this.addButton(buttonsComposite, Messages.UI_SessionEditor_models_button_newSemanticModel, () -> this.addExistingSemanticModel());
        addButton.setToolTipText(Messages.GraphicalSemanticModelsHandler_addModelButton_tooltip);
        this.removeSemanticModelDependencyButton = this.addButton(buttonsComposite, Messages.UI_SessionEditor_models_button_removeSemanticModel, () -> {
            if (theTreeViewer != null) {
                IStructuredSelection selection = (IStructuredSelection)theTreeViewer.getSelection();
                List selectedObjects = selection.toList();
                if (!selectedObjects.isEmpty()) {
                    Collection semanticResources = selectedObjects.stream().filter(Resource.class::isInstance).map(Resource.class::cast).collect(Collectors.toSet());
                    if (!semanticResources.isEmpty() && semanticResources.size() == selectedObjects.size()) {
                        RemoveSemanticResourceAction removeSemanticResourceAction = new RemoveSemanticResourceAction(semanticResources, this.session);
                        removeSemanticResourceAction.run();
                    }
                }
                theTreeViewer.refresh();
            }
        });
        this.removeSemanticModelDependencyButton.setEnabled(false);
        this.removeSemanticModelDependencyButton.setToolTipText(Messages.GraphicalSemanticModelsHandler_removeModelButton_tooltip);
    }

    protected void createAndRegisterNewSemanticModel() {
        IFile newModel;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IContainer context = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.session.getSessionResource().getURI().toPlatformString(true))).getParent();
        CreateEMFModelWizard wizard = new CreateEMFModelWizard(EPackage.Registry.INSTANCE, (IStructuredSelection)new StructuredSelection((Object)context));
        if (new WizardDialog(window.getShell(), (IWizard)wizard).open() == 0 && (newModel = wizard.getResult()) != null) {
            try {
                new ProgressMonitorDialog(window.getShell()).run(false, false, monitor -> this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

                    protected void doExecute() {
                        GraphicalSemanticModelsHandler.this.session.addSemanticResource(URI.createPlatformResourceURI((String)newModel.getFullPath().toString(), (boolean)true), monitor);
                    }
                }));
            }
            catch (InterruptedException | InvocationTargetException e) {
                SessionEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    protected void addExistingSemanticModel() {
        AddModelDependencyAction addModelDependencyAction = new AddModelDependencyAction(this.session, false);
        addModelDependencyAction.run();
    }

    private CommonViewer createModelExplorerNavigator(Composite parent) {
        FilteredCommonTree commonTree = new FilteredCommonTree(SEMANTIC_MODELS_VIEWER_ID, parent, 2050, true);
        commonTree.getPatternFilter().setIncludeLeadingWildcard(true);
        INavigatorContentService contentService = NavigatorContentServiceFactory.INSTANCE.createContentService(SEMANTIC_MODELS_VIEWER_ID, (StructuredViewer)this.treeViewer);
        this.treeViewer = commonTree.getViewer();
        contentService.createCommonContentProvider();
        contentService.createCommonLabelProvider();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
        this.treeViewer.getTree().setHeaderVisible(false);
        this.treeViewer.getTree().setLinesVisible(false);
        GridData layoutData = (GridData)this.treeViewer.getTree().getLayoutData();
        layoutData.heightHint = 50;
        this.siriusCommonContentModelProvider = new SiriusCommonContentProvider(this.session);
        this.updateViewerInput();
        INavigatorFilterService filterService = contentService.getFilterService();
        ViewerFilter[] visibleFilters = filterService.getVisibleFilters(true);
        int i = 0;
        while (i < visibleFilters.length) {
            this.treeViewer.addFilter(visibleFilters[i]);
            ++i;
        }
        contentService.update();
        this.treeViewer.setSorter((ViewerSorter)new RepresentationInSemanticSorter());
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.ecoreActionsHandler = new EcoreActionsHandler((TreeViewer)this.treeViewer, this.actionBars, this.menuManager, this.selectionProvider);
        this.ecoreActionsHandler.initModelsActionsAndListeners();
        this.menuManager.addMenuListener(manager -> {
            this.manageSessionActionProvider.setContext(new ActionContext(this.treeViewer.getSelection()));
            this.manageSessionActionProvider.fillContextMenu((IMenuManager)this.menuManager);
        });
        Menu menu = this.menuManager.createContextMenu(this.treeViewer.getControl());
        this.manageSessionActionProvider = new ManageSessionActionProvider();
        this.manageSessionActionProvider.initFromViewer((StructuredViewer)this.treeViewer);
        this.treeViewer.getControl().setMenu(menu);
        ICommonViewerSite createCommonViewerSite = CommonViewerSiteFactory.createCommonViewerSite((String)SEMANTIC_MODELS_VIEWER_ID, (ISelectionProvider)this.selectionProvider, (Shell)this.treeViewer.getControl().getShell());
        NavigatorActionService actionService = new NavigatorActionService(createCommonViewerSite, (StructuredViewer)this.treeViewer, this.treeViewer.getNavigatorContentService());
        actionService.prepareMenuForPlatformContributions(this.menuManager, (ISelectionProvider)this.treeViewer, true);
        this.menuManager.addMenuListener(manager -> {
            actionService.setContext(new ActionContext(this.treeViewer.getSelection()));
            actionService.fillContextMenu((IMenuManager)this.menuManager);
        });
        this.menuManager.add((IContributionItem)new Separator("additions"));
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                GraphicalSemanticModelsHandler.this.site.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Command mostRecentCommand;
                        if (GraphicalSemanticModelsHandler.this.treeViewer != null && !GraphicalSemanticModelsHandler.this.treeViewer.getTree().isDisposed() && (mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand()) != null) {
                            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
                            if (!affectedObjects.isEmpty()) {
                                GraphicalSemanticModelsHandler.this.setSelectionToViewer(affectedObjects);
                            } else {
                                Tree tree = GraphicalSemanticModelsHandler.this.treeViewer.getTree();
                                if (!tree.isDisposed() && tree.getItems().length > 0 && !tree.getItem(0).isDisposed()) {
                                    ArrayList<Object> selectionCollection = new ArrayList<Object>();
                                    selectionCollection.add(tree.getItem(0).getData());
                                    GraphicalSemanticModelsHandler.this.setSelectionToViewer(selectionCollection);
                                }
                            }
                            GraphicalSemanticModelsHandler.this.actionBars.updateActionBars();
                        }
                    }
                });
            }
        };
        this.session.getTransactionalEditingDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
        return this.treeViewer;
    }

    public void setSelectionToViewer(Collection<?> selectionCollection) {
        final Collection<?> theSelection = selectionCollection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (GraphicalSemanticModelsHandler.this.treeViewer != null) {
                        GraphicalSemanticModelsHandler.this.treeViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.site.getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void updateViewerInput() {
        if (this.session != null && this.treeViewer != null && this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            Object[] children = this.siriusCommonContentModelProvider.getChildren((Object)this.session);
            ArrayList<NoDynamicProjectDependencies> childrenList = new ArrayList<NoDynamicProjectDependencies>();
            Resource sessionResource = this.session.getSessionResource();
            IFile file = WorkspaceSynchronizer.getFile((Resource)sessionResource);
            NoDynamicProjectDependencies projectDependenciesItem = new NoDynamicProjectDependencies(file.getProject(), this.session);
            List<Object> directChildOfProjectDependency = Arrays.asList(this.siriusCommonContentModelProvider.getChildren((Object)projectDependenciesItem));
            childrenList.add(projectDependenciesItem);
            List<Object> itemsWithProjectDependenciesChildren = Arrays.asList(children);
            childrenList.addAll(itemsWithProjectDependenciesChildren.stream().filter(input -> !(input instanceof ViewpointsFolderItemImpl) && !directChildOfProjectDependency.contains(input)).collect(Collectors.toList()));
            childrenList.addAll(Arrays.asList(this.siriusCommonContentModelProvider.getChildren((Object)file.getProject())).stream().filter(input -> !(input instanceof ProjectDependenciesItem)).collect(Collectors.toList()));
            this.treeViewer.setInput(childrenList);
            this.treeViewer.expandToLevel(2);
            this.treeViewer.expandToLevel((Object)projectDependenciesItem, 2);
        }
    }

    protected Button addButton(Composite parent, String name, final Runnable body) {
        Button button = this.toolkit.createButton(parent, name, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (body != null) {
                    body.run();
                }
            }
        });
        return button;
    }

    public void notify(int changeKind) {
        switch (changeKind) {
            case 0: 
            case 11: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.updateViewerInput());
                break;
            }
        }
    }

    public void dispose() {
        if (this.siriusCommonContentModelProvider != null) {
            this.siriusCommonContentModelProvider.dispose();
            this.siriusCommonContentModelProvider = null;
        }
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
        if (this.session != null && this.session.getTransactionalEditingDomain() != null) {
            this.session.getTransactionalEditingDomain().getCommandStack().removeCommandStackListener(this.commandStackListener);
            this.session.removeListener((SessionListener)this);
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.resourceSetListenerChangeListener);
        }
        this.session = null;
        this.treeViewer = null;
        this.manageSessionActionProvider = null;
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        this.toolkit = null;
        this.ecoreActionsHandler = null;
        if (this.lockDecorationUpdater != null) {
            this.lockDecorationUpdater.unregister();
            this.lockDecorationUpdater = null;
        }
    }

    public void notifyAddSession(Session newSession) {
    }

    public void notifyRemoveSession(Session removedSession) {
        this.siriusCommonContentModelProvider.removeRefreshViewerTriggers(removedSession);
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(final Session updated, int notification) {
        if (this.session.equals(updated)) {
            switch (notification) {
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 10: 
                case 11: 
                case 16: {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (GraphicalSemanticModelsHandler.this.treeViewer != null && !GraphicalSemanticModelsHandler.this.treeViewer.getTree().isDisposed()) {
                                GraphicalSemanticModelsHandler.this.treeViewer.refresh();
                                ISelection selection = GraphicalSemanticModelsHandler.this.treeViewer.getSelection();
                                if (selection.isEmpty()) {
                                    selection = new StructuredSelection(GraphicalSemanticModelsHandler.this.treeViewer.getTree().getItem(0).getData());
                                }
                                GraphicalSemanticModelsHandler.this.treeViewer.setSelection(selection);
                            }
                        }
                    });
                    break;
                }
                case 7: {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (GraphicalSemanticModelsHandler.this.treeViewer != null && !GraphicalSemanticModelsHandler.this.treeViewer.getTree().isDisposed()) {
                                GraphicalSemanticModelsHandler.this.treeViewer.refresh();
                                GraphicalSemanticModelsHandler.this.siriusCommonContentModelProvider.addRefreshViewerTrigger(updated);
                            }
                        }
                    });
                    break;
                }
            }
        }
    }

    private class EcoreActionsHandler {
        private DeleteAction deleteAction;
        private CutAction cutAction;
        private CopyAction copyAction;
        private PasteAction pasteAction;
        private UndoAction undoAction;
        private RedoAction redoAction;
        private MenuManager submenuNewChildManager;
        private MenuManager submenuNewSiblingManager;
        private IActionBars actionBars;
        private ISelectionProvider selectionProvider;
        private TreeViewer treeViewer;
        private MenuManager menuManager;
        private Action deleteActionHandler;
        private Action renameActionHandler;

        EcoreActionsHandler(TreeViewer theTreeViewer, IActionBars theActionBars, MenuManager theMenuManager, ISelectionProvider theSelectionProvider) {
            this.treeViewer = theTreeViewer;
            this.actionBars = theActionBars;
            this.menuManager = theMenuManager;
            this.selectionProvider = theSelectionProvider;
        }

        public void initModelsActionsAndListeners() {
            this.deleteActionHandler = new DeleteActionHandler((ISelectionProvider)this.treeViewer);
            this.renameActionHandler = new RenameActionHandler((ISelectionProvider)this.treeViewer);
            this.deleteActionHandler.setEnabled(false);
            this.renameActionHandler.setEnabled(false);
            this.initActionsAndActionBar();
            this.initMenuListener();
            this.initSelectionListener();
            this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent event) {
                    EcoreActionsHandler.this.handleKeyReleased(event);
                }
            });
        }

        private void initSelectionListener() {
            this.treeViewer.addSelectionChangedListener(event -> {
                if (GraphicalSemanticModelsHandler.this.session == null || GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain() == null || GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain().getCommandStack() == null) {
                    return;
                }
                TreeSelection selection = (TreeSelection)event.getSelection();
                if (event.getSelection().isEmpty()) {
                    this.deleteActionHandler.setEnabled(false);
                    this.renameActionHandler.setEnabled(false);
                    GraphicalSemanticModelsHandler.this.removeSemanticModelDependencyButton.setEnabled(false);
                } else {
                    List selectedObjects;
                    Object firstElement = selection.getFirstElement();
                    if (firstElement instanceof EObject && !(firstElement instanceof DRepresentationDescriptor)) {
                        this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
                        this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
                        this.deleteActionHandler.setEnabled(false);
                        this.renameActionHandler.setEnabled(false);
                    } else if (firstElement instanceof DRepresentationDescriptor) {
                        this.deleteActionHandler.setEnabled(true);
                        this.renameActionHandler.setEnabled(true);
                        this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteActionHandler);
                        this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameActionHandler);
                    }
                    Stream<Object> selectionAsStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(selection.iterator(), 16), false);
                    boolean allSelectionCanBeEdited = selectionAsStream.filter(object -> object instanceof EObject).map(EObject.class::cast).allMatch(eObject -> PermissionAuthorityRegistry.getDefault().getPermissionAuthority(eObject).canEditInstance(eObject));
                    this.deleteAction.setEnabled(allSelectionCanBeEdited);
                    this.deleteAction.updateSelection((IStructuredSelection)selection);
                    this.cutAction.updateSelection((IStructuredSelection)selection);
                    this.copyAction.updateSelection((IStructuredSelection)selection);
                    this.pasteAction.updateSelection((IStructuredSelection)selection);
                    this.undoAction.update();
                    this.redoAction.update();
                    this.actionBars.updateActionBars();
                    if (this.treeViewer != null && !(selectedObjects = selection.toList()).isEmpty()) {
                        Collection semanticResources = selectedObjects.stream().filter(Resource.class::isInstance).map(Resource.class::cast).collect(Collectors.toSet());
                        if (!semanticResources.isEmpty() && semanticResources.size() == selectedObjects.size()) {
                            GraphicalSemanticModelsHandler.this.removeSemanticModelDependencyButton.setEnabled(true);
                        } else {
                            GraphicalSemanticModelsHandler.this.removeSemanticModelDependencyButton.setEnabled(false);
                        }
                    }
                }
            });
        }

        private void handleKeyReleased(KeyEvent event) {
            if (event.stateMask != 0) {
                return;
            }
            int key = event.keyCode;
            if (key == 127) {
                if (this.deleteActionHandler.isEnabled()) {
                    this.deleteActionHandler.run();
                }
            } else if (key == 0x100000B && this.renameActionHandler.isEnabled()) {
                this.renameActionHandler.run();
            }
        }

        private void initActionsAndActionBar() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.deleteAction = this.createDeleteAction();
            this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.cutAction = this.createCutAction();
            this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.copyAction = this.createCopyAction();
            this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.pasteAction = this.createPasteAction();
            this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            this.undoAction = this.createUndoAction();
            this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
            this.redoAction = this.createRedoAction();
            this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameActionHandler);
            this.actionBars.updateActionBars();
        }

        private void initMenuListener() {
            this.menuManager.addMenuListener(manager -> {
                TreeSelection selection = (TreeSelection)this.treeViewer.getSelection();
                List selectionList = selection.toList();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof EObject && !(firstElement instanceof DRepresentationDescriptor)) {
                    if (selectionList.size() == 1) {
                        Collection newChildDescriptors = GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain().getNewChildDescriptors(firstElement, null);
                        GraphicalSemanticModelsHandler.this.createChildActions = this.generateCreateChildActions(newChildDescriptors, (ISelection)selection);
                        Collection newSiblingDescriptors = GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain().getNewChildDescriptors(null, firstElement);
                        GraphicalSemanticModelsHandler.this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, (ISelection)selection);
                        this.submenuNewChildManager = new MenuManager("&New Child");
                        this.menuManager.add((IContributionItem)this.submenuNewChildManager);
                        this.submenuNewSiblingManager = new MenuManager("N&ew Sibling");
                        this.menuManager.add((IContributionItem)this.submenuNewSiblingManager);
                        this.populateManager((IContributionManager)this.submenuNewChildManager, GraphicalSemanticModelsHandler.this.createChildActions);
                        this.populateManager((IContributionManager)this.submenuNewSiblingManager, GraphicalSemanticModelsHandler.this.createSiblingActions);
                    }
                    this.menuManager.add((IContributionItem)new Separator());
                    this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
                    this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
                    this.menuManager.add((IContributionItem)new Separator());
                    this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
                    this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
                    this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
                    this.menuManager.add((IContributionItem)new Separator());
                    this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
                    this.menuManager.add((IContributionItem)new Separator());
                }
            });
        }

        private DeleteAction createDeleteAction() {
            return new DeleteAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain(), this.removeAllReferencesOnDelete());
        }

        private CutAction createCutAction() {
            return new CutAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain());
        }

        private CopyAction createCopyAction() {
            return new CopyAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain());
        }

        private PasteAction createPasteAction() {
            return new PasteAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain());
        }

        private UndoAction createUndoAction() {
            return new UndoAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain());
        }

        private RedoAction createRedoAction() {
            return new RedoAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain());
        }

        protected boolean removeAllReferencesOnDelete() {
            return false;
        }

        private Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
            ArrayList<IAction> actions = new ArrayList<IAction>();
            if (descriptors != null) {
                for (Object descriptor : descriptors) {
                    actions.add((IAction)new CreateChildAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain(), selection, descriptor));
                }
            }
            return actions;
        }

        private Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
            ArrayList<IAction> actions = new ArrayList<IAction>();
            if (descriptors != null) {
                for (Object descriptor : descriptors) {
                    actions.add((IAction)new CreateSiblingAction((EditingDomain)GraphicalSemanticModelsHandler.this.session.getTransactionalEditingDomain(), selection, descriptor));
                }
            }
            return actions;
        }

        private void populateManager(IContributionManager manager, Collection<? extends IAction> actions) {
            if (actions != null) {
                for (IAction iAction : actions) {
                    manager.add(iAction);
                }
            }
        }
    }

    private final class ResourceSetListenerChangeListener
    implements ResourceSetListener {
        private ResourceSetListenerChangeListener() {
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            return null;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            for (Notification notification : event.getNotifications()) {
                switch (notification.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (!(notification.getNotifier() instanceof DAnalysis)) break;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                            GraphicalSemanticModelsHandler.this.updateViewerInput();
                            if (GraphicalSemanticModelsHandler.this.treeViewer != null && GraphicalSemanticModelsHandler.this.treeViewer.getTree() != null && !GraphicalSemanticModelsHandler.this.treeViewer.getTree().isDisposed()) {
                                GraphicalSemanticModelsHandler.this.treeViewer.refresh();
                            }
                        });
                        break;
                    }
                }
            }
        }

        public boolean isPrecommitOnly() {
            return false;
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public NotificationFilter getFilter() {
            return null;
        }

        public boolean isAggregatePrecommitListener() {
            return false;
        }
    }
}

