/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.migration;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class ViewWithNullElementMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("12.1.3.201809191200");
    public static final String DVIEW_OWNED_REPRESENTATIONS_UNKNOWN_FEATURE = "ownedRepresentations";
    private boolean repairOccurred;
    private StringBuilder sb;

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(dView).getLoadedRepresentations(), DDiagram.class)) {
                    this.repairViewWihtoutElement(dDiagram);
                }
            }
            super.postLoad(dAnalysis, loadedVersion);
        }
    }

    private void repairViewWihtoutElement(DDiagram dDiagram) {
        DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
        if (diagramCreationUtil.findAssociatedGMFDiagram()) {
            Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
            this.repairViewWihtoutElement(gmfDiagram, dDiagram.getName());
        }
    }

    public void postLoad(XMLResource resource, String loadedVersion) {
        this.repairOccurred = false;
        this.sb = new StringBuilder(Messages.ViewWithNullElementMigrationParticipant_title);
        super.postLoad(resource, loadedVersion);
        if (this.repairOccurred) {
            DiagramPlugin.getDefault().logInfo(this.sb.toString());
        }
    }

    private void repairViewWihtoutElement(Diagram gmfDiagram, String diagramName) {
        int fixedViews = 0;
        TreeIterator iterator = gmfDiagram.eAllContents();
        while (iterator.hasNext()) {
            EObject elt = (EObject)iterator.next();
            if (!(elt instanceof View) || !ViewWithNullElementMigrationParticipant.needsElementUpdateToExplicitNull((View)elt)) continue;
            iterator.prune();
            ViewWithNullElementMigrationParticipant.updateElementToExplicitNull((View)elt);
            ++fixedViews;
        }
        if (fixedViews == 1) {
            this.repairOccurred = true;
            this.sb.append(MessageFormat.format(Messages.ViewWithNullElementMigrationParticipant_singleMessage, diagramName));
        } else if (fixedViews > 1) {
            this.repairOccurred = true;
            this.sb.append(MessageFormat.format(Messages.ViewWithNullElementMigrationParticipant_message, fixedViews, diagramName));
        }
    }

    protected void handleFeature(EObject owner, EStructuralFeature unkownFeature, Object valueOfUnknownFeature) {
        if (DVIEW_OWNED_REPRESENTATIONS_UNKNOWN_FEATURE.equals(unkownFeature.getName()) && valueOfUnknownFeature instanceof DDiagram && owner instanceof DView) {
            this.repairViewWihtoutElement((DDiagram)valueOfUnknownFeature);
        }
    }

    public static boolean needsElementUpdateToExplicitNull(View view) {
        if (!view.isSetElement()) {
            boolean knownBrokenEdgeCase;
            String viewType = view.getType();
            boolean knownBrokenNodeCase = view instanceof Shape && (ViewType.NOTE.equals(viewType) || ViewType.TEXT.equals(viewType));
            boolean bl = knownBrokenEdgeCase = view instanceof Connector && ViewType.NOTEATTACHMENT.equals(viewType);
            return knownBrokenNodeCase || knownBrokenEdgeCase;
        }
        return false;
    }

    public static void updateElementToExplicitNull(View view) {
        view.setElement(null);
        view.eAllContents().forEachRemaining(elt -> {
            if (elt instanceof View && !((View)elt).isSetElement()) {
                ((View)elt).setElement(null);
            }
        });
    }
}

