/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.template;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ConditionalEdgeStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalNodeStyleDescription;
import org.eclipse.sirius.diagram.description.FoldingStyle;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.diagram.sequence.description.BasicMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.CreationMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.DestructionMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.EndOfLifeMapping;
import org.eclipse.sirius.diagram.sequence.description.ExecutionMapping;
import org.eclipse.sirius.diagram.sequence.description.InstanceRoleMapping;
import org.eclipse.sirius.diagram.sequence.description.MessageMapping;
import org.eclipse.sirius.diagram.sequence.description.ReturnMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.diagram.sequence.template.AbstractRule;
import org.eclipse.sirius.diagram.sequence.template.ModelGeneratedMaker;
import org.eclipse.sirius.diagram.sequence.template.TBasicMessageMapping;
import org.eclipse.sirius.diagram.sequence.template.TConditionalExecutionStyle;
import org.eclipse.sirius.diagram.sequence.template.TConditionalLifelineStyle;
import org.eclipse.sirius.diagram.sequence.template.TConditionalMessageStyle;
import org.eclipse.sirius.diagram.sequence.template.TCreationMessageMapping;
import org.eclipse.sirius.diagram.sequence.template.TDestructionMessageMapping;
import org.eclipse.sirius.diagram.sequence.template.TExecutionMapping;
import org.eclipse.sirius.diagram.sequence.template.TExecutionStyle;
import org.eclipse.sirius.diagram.sequence.template.TLifelineMapping;
import org.eclipse.sirius.diagram.sequence.template.TLifelineStyle;
import org.eclipse.sirius.diagram.sequence.template.TMessageStyle;
import org.eclipse.sirius.diagram.sequence.template.TReturnMessageMapping;
import org.eclipse.sirius.diagram.sequence.template.TSequenceDiagram;
import org.eclipse.sirius.diagram.sequence.template.TSourceTargetMessageMapping;
import org.eclipse.sirius.tools.api.command.semantic.RemoveDanglingReferences;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public class TemplateToDiagramDescriptionTransformer {
    private TSequenceDiagram template;
    private Collection<Runnable> posts;
    private ModelGeneratedMaker marker = new ModelGeneratedMaker();
    private Template2SequenceDiag template2SequenceDiag = new Template2SequenceDiag(this.marker);
    private Lifeline2InstanceRoleMapping lifeline2InstanceRoleMapping = new Lifeline2InstanceRoleMapping(this.marker);
    private Lifeline2ExecutionMapping lifeline2ExecutionMapping = new Lifeline2ExecutionMapping(this.marker);
    private Lifeline2EndOfLifeMapping lifeline2EndOfLineMapping = new Lifeline2EndOfLifeMapping(this.marker);
    private Execution2ExecutionMapping execution2ExecutionMaping = new Execution2ExecutionMapping(this.marker);
    private TBasicMessage2EdgeMapping basicMessageToEdgeMapping = new TBasicMessage2EdgeMapping(this.marker);
    private TCreationMessage2EdgeMapping creationMessageToEdgeMapping = new TCreationMessage2EdgeMapping(this.marker);
    private TDestructionMessage2EdgeMapping destructionMessageToEdgeMapping = new TDestructionMessage2EdgeMapping(this.marker);
    private TReturnMessage2EdgeMapping returnMessageToEdgeMapping = new TReturnMessage2EdgeMapping(this.marker);
    private TMessageStyle2EdgeStyle messageStyleToEdgeStyle = new TMessageStyle2EdgeStyle(this.marker);
    private TConditionalMessageStyle2ConditionalEdgeStyle conditionalMessageStyleToConditional = new TConditionalMessageStyle2ConditionalEdgeStyle(this.marker);
    private TLifelineStyle2NodeStyle lifelineStyleToNodeStyle = new TLifelineStyle2NodeStyle(this.marker);
    private TConditionalLifelineStyle2ConditionalNodeStyle conditionalLifelineStyleToNodeStyle = new TConditionalLifelineStyle2ConditionalNodeStyle(this.marker);
    private TExecutionStyle2NodeStyle executionStyleToNodeStyle = new TExecutionStyle2NodeStyle(this.marker);
    private TConditionalExecutionStyle2NodeStyle conditionalExecutionStyleToNodeStyle = new TConditionalExecutionStyle2NodeStyle(this.marker);

    public TemplateToDiagramDescriptionTransformer(TSequenceDiagram template) {
        this.template = template;
        this.posts = new ArrayList<Runnable>();
    }

    private void copyMappingData(TSourceTargetMessageMapping from, MessageMapping to) {
        to.setName(from.getName());
        to.setDomainClass(from.getDomainClass());
        to.setSemanticCandidatesExpression(from.getSemanticCandidatesExpression());
        to.setSourceFinderExpression(from.getSourceFinderExpression());
        to.setTargetFinderExpression(from.getTargetFinderExpression());
        to.setSendingEndFinderExpression(from.getSendingEndFinderExpression());
        to.setReceivingEndFinderExpression(from.getReceivingEndFinderExpression());
        to.setUseDomainElement(from.isUseDomainElement());
        if (from.getStyle() != null) {
            to.setStyle(this.messageStyleToEdgeStyle.apply(from.getStyle()));
        }
        this.marker.clearGenerateds((List<? extends EObject>)to.getConditionnalStyles());
        to.getConditionnalStyles().addAll(AbstractRule.transform(from.getConditionalStyle(), this.conditionalMessageStyleToConditional));
    }

    public SequenceDiagramDescription refresh() {
        SequenceDiagramDescription description = this.template2SequenceDiag.apply(this.template);
        this.template.getOwnedRepresentations().add((Object)description);
        this.postProcess();
        this.cleanDanglingReferences();
        return description;
    }

    private void cleanDanglingReferences() {
        RemoveDanglingReferences.removeDanglingReferences((EObject)this.template);
    }

    private void postProcess() {
        for (Runnable postProcess : this.posts) {
            postProcess.run();
        }
    }

    private void postOp(Runnable runnable) {
        this.posts.add(runnable);
    }

    public boolean isOverriding(EObject eObj, EStructuralFeature feature) {
        LinkedHashSet<Object> overriden = new LinkedHashSet<Object>();
        overriden.add(DescriptionPackage.eINSTANCE.getIdentifiedElement_Name());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDiagramDescription_DomainClass());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDiagramDescription_NodeMappings());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getAbstractNodeMapping_DomainClass());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_DomainClass());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_SourceMapping());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_TargetMapping());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_SourceFinderExpression());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_TargetFinderExpression());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_UseDomainElement());
        overriden.add(StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression());
        overriden.add(StylePackage.eINSTANCE.getBasicLabelStyleDescription_ShowIcon());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticCandidatesExpression());
        overriden.add(org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDiagramElementMapping_CreateElements());
        overriden.add(org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getSequenceDiagramDescription_EndsOrdering());
        overriden.add(org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getDelimitedEventMapping_FinishingEndFinderExpression());
        overriden.add(org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getDelimitedEventMapping_StartingEndFinderExpression());
        overriden.add(org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getReturnMessageMapping_InvocationMessageFinderExpression());
        overriden.add(org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getMessageMapping_ReceivingEndFinderExpression());
        overriden.add(org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getMessageMapping_SendingEndFinderExpression());
        return overriden.contains(feature);
    }

    private EObject copy(EObject src) {
        if (src != null) {
            return EcoreUtil.copy((EObject)src);
        }
        return null;
    }

    private class Execution2ExecutionMapping
    extends AbstractRule<TExecutionMapping, ExecutionMapping> {
        Execution2ExecutionMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public ExecutionMapping apply(TExecutionMapping from) {
            ExecutionMapping to = (ExecutionMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping());
            to.setName(from.getName());
            to.setDomainClass(from.getDomainClass());
            to.setSemanticCandidatesExpression(from.getSemanticCandidatesExpression());
            to.setFinishingEndFinderExpression(from.getFinishingEndFinderExpression());
            to.setStartingEndFinderExpression(from.getStartingEndFinderExpression());
            to.getReusedBorderedNodeMappings().clear();
            if (from.isRecursive()) {
                to.getReusedBorderedNodeMappings().add((Object)to);
            }
            if (from.getStyle() != null) {
                to.setStyle((NodeStyleDescription)TemplateToDiagramDescriptionTransformer.this.executionStyleToNodeStyle.apply(from.getStyle()));
            }
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getConditionnalStyles());
            to.getConditionnalStyles().addAll(AbstractRule.transform(from.getConditionalStyles(), TemplateToDiagramDescriptionTransformer.this.conditionalExecutionStyleToNodeStyle));
            to.getBorderedNodeMappings().addAll(AbstractRule.transform(from.getExecutionMappings(), TemplateToDiagramDescriptionTransformer.this.execution2ExecutionMaping));
            return to;
        }
    }

    private class Lifeline2EndOfLifeMapping
    extends AbstractRule<TLifelineMapping, EndOfLifeMapping> {
        private static final String SELF = "var:self";

        Lifeline2EndOfLifeMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public EndOfLifeMapping apply(TLifelineMapping from) {
            EndOfLifeMapping to = (EndOfLifeMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getEndOfLifeMapping());
            to.setName(String.valueOf(from.getName()) + " EOL");
            to.setSemanticCandidatesExpression(SELF);
            to.setSemanticElements(SELF);
            to.setDomainClass(from.getDomainClass());
            to.setCreateElements(true);
            to.setPreconditionExpression(from.getEolVisibleExpression());
            to.setStyle((NodeStyleDescription)TemplateToDiagramDescriptionTransformer.this.copy((EObject)from.getEndOfLifeStyle()));
            return to;
        }
    }

    private class Lifeline2ExecutionMapping
    extends AbstractRule<TLifelineMapping, ExecutionMapping> {
        private static final String SELF = "var:self";

        Lifeline2ExecutionMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public ExecutionMapping apply(TLifelineMapping from) {
            ExecutionMapping to = (ExecutionMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping());
            to.setName(String.valueOf(from.getName()) + " Execution");
            to.setDomainClass(from.getDomainClass());
            to.setSemanticCandidatesExpression(SELF);
            to.setStartingEndFinderExpression(SELF);
            to.setFinishingEndFinderExpression(SELF);
            if (from.getLifelineStyle() != null) {
                to.setStyle((NodeStyleDescription)TemplateToDiagramDescriptionTransformer.this.lifelineStyleToNodeStyle.apply(from.getLifelineStyle()));
            }
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getConditionnalStyles());
            to.getConditionnalStyles().addAll(AbstractRule.transform(from.getConditionalLifeLineStyles(), TemplateToDiagramDescriptionTransformer.this.conditionalLifelineStyleToNodeStyle));
            to.setCreateElements(true);
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getBorderedNodeMappings());
            to.getBorderedNodeMappings().addAll(AbstractRule.transform(from.getExecutionMappings(), TemplateToDiagramDescriptionTransformer.this.execution2ExecutionMaping));
            to.getBorderedNodeMappings().add((Object)TemplateToDiagramDescriptionTransformer.this.lifeline2EndOfLineMapping.apply(from));
            return to;
        }
    }

    private class Lifeline2InstanceRoleMapping
    extends AbstractRule<TLifelineMapping, InstanceRoleMapping> {
        Lifeline2InstanceRoleMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public InstanceRoleMapping apply(TLifelineMapping from) {
            InstanceRoleMapping to = (InstanceRoleMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getInstanceRoleMapping());
            to.setName(String.valueOf(from.getName()) + " Instance Role");
            to.setDomainClass(from.getDomainClass());
            to.setSemanticCandidatesExpression(from.getSemanticCandidatesExpression());
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getBorderedNodeMappings());
            to.getBorderedNodeMappings().add((Object)TemplateToDiagramDescriptionTransformer.this.lifeline2ExecutionMapping.apply(from));
            to.setCreateElements(true);
            to.setStyle((NodeStyleDescription)TemplateToDiagramDescriptionTransformer.this.copy((EObject)from.getInstanceRoleStyle()));
            if (to.getStyle() != null) {
                to.getStyle().setResizeKind(ResizeKind.NSEW_LITERAL);
            }
            return to;
        }
    }

    private class TBasicMessage2EdgeMapping
    extends AbstractRule<TBasicMessageMapping, BasicMessageMapping> {
        TBasicMessage2EdgeMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public BasicMessageMapping apply(final TBasicMessageMapping from) {
            final BasicMessageMapping to = (BasicMessageMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getBasicMessageMapping());
            TemplateToDiagramDescriptionTransformer.this.copyMappingData(from, to);
            TemplateToDiagramDescriptionTransformer.this.postOp(new Runnable(){

                @Override
                public void run() {
                    Collection<EObject> sourceOutputs = AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.execution2ExecutionMaping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getSource());
                    sourceOutputs.addAll(AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.lifeline2ExecutionMapping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getSource()));
                    to.getSourceMapping().clear();
                    to.getSourceMapping().addAll((Collection)Lists.newArrayList((Iterable)Iterables.filter(sourceOutputs, AbstractNodeMapping.class)));
                    Collection<EObject> targetOutputs = AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.execution2ExecutionMaping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getTarget());
                    targetOutputs.addAll(AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.lifeline2ExecutionMapping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getTarget()));
                    to.getTargetMapping().clear();
                    to.getTargetMapping().addAll((Collection)Lists.newArrayList((Iterable)Iterables.filter(targetOutputs, AbstractNodeMapping.class)));
                }
            });
            return to;
        }
    }

    private class TConditionalExecutionStyle2NodeStyle
    extends AbstractRule<TConditionalExecutionStyle, ConditionalNodeStyleDescription> {
        TConditionalExecutionStyle2NodeStyle(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public ConditionalNodeStyleDescription apply(TConditionalExecutionStyle from) {
            ConditionalNodeStyleDescription to = (ConditionalNodeStyleDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getConditionalNodeStyleDescription());
            to.setPredicateExpression(from.getPredicateExpression());
            if (from.getStyle() != null) {
                to.setStyle((NodeStyleDescription)TemplateToDiagramDescriptionTransformer.this.executionStyleToNodeStyle.apply(from.getStyle()));
            }
            return to;
        }
    }

    private class TConditionalLifelineStyle2ConditionalNodeStyle
    extends AbstractRule<TConditionalLifelineStyle, ConditionalNodeStyleDescription> {
        TConditionalLifelineStyle2ConditionalNodeStyle(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public ConditionalNodeStyleDescription apply(TConditionalLifelineStyle from) {
            ConditionalNodeStyleDescription to = (ConditionalNodeStyleDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getConditionalNodeStyleDescription());
            to.setPredicateExpression(from.getPredicateExpression());
            if (from.getStyle() != null) {
                to.setStyle((NodeStyleDescription)TemplateToDiagramDescriptionTransformer.this.lifelineStyleToNodeStyle.apply(from.getStyle()));
            }
            return to;
        }
    }

    private class TConditionalMessageStyle2ConditionalEdgeStyle
    extends AbstractRule<TConditionalMessageStyle, ConditionalEdgeStyleDescription> {
        TConditionalMessageStyle2ConditionalEdgeStyle(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public ConditionalEdgeStyleDescription apply(TConditionalMessageStyle from) {
            ConditionalEdgeStyleDescription to = (ConditionalEdgeStyleDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getConditionalEdgeStyleDescription());
            to.setPredicateExpression(from.getPredicateExpression());
            if (from.getStyle() != null) {
                to.setStyle(TemplateToDiagramDescriptionTransformer.this.messageStyleToEdgeStyle.apply(from.getStyle()));
            }
            return to;
        }
    }

    private class TCreationMessage2EdgeMapping
    extends AbstractRule<TCreationMessageMapping, CreationMessageMapping> {
        TCreationMessage2EdgeMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public CreationMessageMapping apply(final TCreationMessageMapping from) {
            final CreationMessageMapping to = (CreationMessageMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getCreationMessageMapping());
            TemplateToDiagramDescriptionTransformer.this.copyMappingData(from, to);
            TemplateToDiagramDescriptionTransformer.this.postOp(new Runnable(){

                @Override
                public void run() {
                    Collection<EObject> sourceOutputs = AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.execution2ExecutionMaping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getSource());
                    sourceOutputs.addAll(AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.lifeline2ExecutionMapping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getSource()));
                    to.getSourceMapping().clear();
                    to.getSourceMapping().addAll((Collection)Lists.newArrayList((Iterable)Iterables.filter(sourceOutputs, AbstractNodeMapping.class)));
                    ArrayList<EObject> targetOutputs = new ArrayList<EObject>();
                    targetOutputs.addAll(AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.lifeline2InstanceRoleMapping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getInstanceRoleMapping(), from.getTarget()));
                    to.getTargetMapping().clear();
                    to.getTargetMapping().addAll((Collection)Lists.newArrayList((Iterable)Iterables.filter(targetOutputs, AbstractNodeMapping.class)));
                }
            });
            return to;
        }
    }

    private class TDestructionMessage2EdgeMapping
    extends AbstractRule<TDestructionMessageMapping, DestructionMessageMapping> {
        TDestructionMessage2EdgeMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public DestructionMessageMapping apply(final TDestructionMessageMapping from) {
            final DestructionMessageMapping to = (DestructionMessageMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getDestructionMessageMapping());
            TemplateToDiagramDescriptionTransformer.this.copyMappingData(from, to);
            TemplateToDiagramDescriptionTransformer.this.postOp(new Runnable(){

                @Override
                public void run() {
                    Collection<EObject> sourceOutputs = AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.execution2ExecutionMaping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getSource());
                    sourceOutputs.addAll(AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.lifeline2ExecutionMapping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getExecutionMapping(), from.getSource()));
                    to.getSourceMapping().clear();
                    to.getSourceMapping().addAll((Collection)Lists.newArrayList((Iterable)Iterables.filter(sourceOutputs, AbstractNodeMapping.class)));
                    ArrayList<EObject> targetOutputs = new ArrayList<EObject>();
                    targetOutputs.addAll(AbstractRule.collectGeneratedElements(TemplateToDiagramDescriptionTransformer.this.lifeline2EndOfLineMapping, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getEndOfLifeMapping(), from.getTarget()));
                    to.getTargetMapping().clear();
                    to.getTargetMapping().addAll((Collection)Lists.newArrayList((Iterable)Iterables.filter(targetOutputs, AbstractNodeMapping.class)));
                }
            });
            return to;
        }
    }

    private static class TExecutionStyle2NodeStyle
    extends AbstractRule<TExecutionStyle, SquareDescription> {
        TExecutionStyle2NodeStyle(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public SquareDescription apply(TExecutionStyle from) {
            SquareDescription to = (SquareDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getSquareDescription());
            if (from.getBackgroundColor() != null) {
                to.setColor(from.getBackgroundColor());
            }
            if (from.getBorderColor() != null) {
                to.setBorderColor(from.getBorderColor());
            }
            to.setBorderSizeComputationExpression(from.getBorderSizeComputationExpression());
            to.setResizeKind(ResizeKind.NORTH_SOUTH_LITERAL);
            to.setShowIcon(false);
            to.setLabelExpression("[''/]");
            to.setWidth(Integer.valueOf(2));
            to.setHeight(Integer.valueOf(3));
            return to;
        }
    }

    private static class TLifelineStyle2NodeStyle
    extends AbstractRule<TLifelineStyle, SquareDescription> {
        TLifelineStyle2NodeStyle(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public SquareDescription apply(TLifelineStyle from) {
            SquareDescription to = (SquareDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getSquareDescription());
            to.setBorderColor(from.getLifelineColor());
            to.setBorderSizeComputationExpression(from.getLifelineWidthComputationExpression());
            to.setLabelPosition(LabelPosition.NODE_LITERAL);
            to.setResizeKind(ResizeKind.NSEW_LITERAL);
            to.setWidth(Integer.valueOf(1));
            to.setHeight(Integer.valueOf(40));
            to.setShowIcon(false);
            return to;
        }
    }

    private static class TMessageStyle2EdgeStyle
    extends AbstractRule<TMessageStyle, EdgeStyleDescription> {
        TMessageStyle2EdgeStyle(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public EdgeStyleDescription apply(TMessageStyle from) {
            EdgeStyleDescription to = (EdgeStyleDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getEdgeStyleDescription());
            to.setFoldingStyle(FoldingStyle.NONE_LITERAL);
            to.getCenterLabelStyleDescription().setLabelExpression(from.getLabelExpression());
            to.setLineStyle(from.getLineStyle());
            to.setSourceArrow(from.getSourceArrow());
            to.setStrokeColor(from.getStrokeColor());
            to.setSizeComputationExpression("2");
            to.setTargetArrow(from.getTargetArrow());
            return to;
        }
    }

    private class TReturnMessage2EdgeMapping
    extends AbstractRule<TReturnMessageMapping, ReturnMessageMapping> {
        TReturnMessage2EdgeMapping(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public ReturnMessageMapping apply(TReturnMessageMapping from) {
            ReturnMessageMapping to = (ReturnMessageMapping)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getReturnMessageMapping());
            to.setName(from.getName());
            to.setDomainClass(from.getDomainClass());
            to.setSemanticCandidatesExpression(from.getSemanticCandidatesExpression());
            to.setSendingEndFinderExpression(from.getSendingEndFinderExpression());
            to.setReceivingEndFinderExpression(from.getReceivingEndFinderExpression());
            if (from.getStyle() != null) {
                to.setStyle(TemplateToDiagramDescriptionTransformer.this.messageStyleToEdgeStyle.apply(from.getStyle()));
            }
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getConditionnalStyles());
            to.getConditionnalStyles().addAll(AbstractRule.transform(from.getConditionalStyle(), TemplateToDiagramDescriptionTransformer.this.conditionalMessageStyleToConditional));
            to.setInvocationMessageFinderExpression(from.getInvocationMessageFinderExpression());
            return to;
        }
    }

    private class Template2SequenceDiag
    extends AbstractRule<TSequenceDiagram, SequenceDiagramDescription> {
        Template2SequenceDiag(ModelGeneratedMaker marker) {
            super(marker);
        }

        @Override
        public SequenceDiagramDescription apply(TSequenceDiagram from) {
            SequenceDiagramDescription to = (SequenceDiagramDescription)this.getOrCreate(from, org.eclipse.sirius.diagram.sequence.description.DescriptionPackage.eINSTANCE.getSequenceDiagramDescription());
            to.setName(from.getName());
            to.setEndsOrdering(from.getEndsOrdering());
            to.setDomainClass(from.getDomainClass());
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getNodeMappings());
            to.getNodeMappings().addAll(AbstractRule.transform(from.getLifelineMappings(), TemplateToDiagramDescriptionTransformer.this.lifeline2InstanceRoleMapping));
            TemplateToDiagramDescriptionTransformer.this.marker.clearGenerateds((List<? extends EObject>)to.getEdgeMappings());
            to.getEdgeMappings().addAll(AbstractRule.transform(Lists.newArrayList((Iterable)Iterables.filter(from.getMessageMappings(), TBasicMessageMapping.class)), TemplateToDiagramDescriptionTransformer.this.basicMessageToEdgeMapping));
            to.getEdgeMappings().addAll(AbstractRule.transform(Lists.newArrayList((Iterable)Iterables.filter(from.getMessageMappings(), TCreationMessageMapping.class)), TemplateToDiagramDescriptionTransformer.this.creationMessageToEdgeMapping));
            to.getEdgeMappings().addAll(AbstractRule.transform(Lists.newArrayList((Iterable)Iterables.filter(from.getMessageMappings(), TDestructionMessageMapping.class)), TemplateToDiagramDescriptionTransformer.this.destructionMessageToEdgeMapping));
            to.getEdgeMappings().addAll(AbstractRule.transform(Lists.newArrayList((Iterable)Iterables.filter(from.getMessageMappings(), TReturnMessageMapping.class)), TemplateToDiagramDescriptionTransformer.this.returnMessageToEdgeMapping));
            return to;
        }
    }
}

