/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.wellform;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class WellformAllOperation
implements IOperation {
    @Override
    public String getOperationName() {
        return "Wellform all Scout classes";
    }

    @Override
    public void validate() {
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        String[] roots;
        int numTicks = 100;
        int searchStepTicks = 1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Wellform Scout classes...", (int)numTicks);
        progress.subTask("Searching for classes...");
        HashSet<IType> types = new HashSet<IType>();
        String[] stringArray = roots = new String[]{"org.eclipse.scout.rt.shared.services.common.code.ICodeType", "org.eclipse.scout.rt.client.ui.desktop.IDesktop", "org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension", "org.eclipse.scout.rt.client.ui.form.IForm", "org.eclipse.scout.rt.client.ui.wizard.IWizard", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage", "org.eclipse.scout.rt.client.ui.desktop.outline.IOutline"};
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            Set<IType> rootTypes = S2eUtils.resolveJdtTypes(root);
            for (IType t : rootTypes) {
                ITypeHierarchy codeTypeHierarchy = t.newTypeHierarchy(null);
                IType[] iTypeArray = codeTypeHierarchy.getAllClasses();
                int n3 = iTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType candidate = iTypeArray[n4];
                    if (S2eUtils.exists((IJavaElement)candidate) && !candidate.isInterface() && !candidate.isBinary() && !candidate.isAnonymous() && candidate.getDeclaringType() == null) {
                        types.add(candidate);
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ++n4;
                }
            }
            monitor.worked(searchStepTicks);
            ++n2;
        }
        monitor.subTask("Wellform classes...");
        WellformScoutTypeOperation op = new WellformScoutTypeOperation(types, true);
        op.validate();
        op.run((IProgressMonitor)progress.newChild(numTicks - searchStepTicks * roots.length), workingCopyManager);
        monitor.done();
    }
}

