/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class ImportsCreateOperation
implements IOperation {
    private final Set<String> m_importsToCreate = new TreeSet<String>();
    private final ICompilationUnit m_icu;

    public ImportsCreateOperation(ICompilationUnit icu) {
        this.m_icu = icu;
    }

    public ImportsCreateOperation(ICompilationUnit icu, Set<String> importsToCreate) {
        this(icu);
        if (importsToCreate != null) {
            this.setImportsToCreate(importsToCreate);
        }
    }

    public ImportsCreateOperation(ICompilationUnit icu, IImportCollector validator) {
        this(icu);
        if (validator != null) {
            this.setImportsToCreate(validator.getImports());
        }
    }

    @Override
    public String getOperationName() {
        return "Create imports";
    }

    @Override
    public void validate() {
        if (!S2eUtils.exists((IJavaElement)this.getCompilationUnit())) {
            throw new IllegalArgumentException("Compilation unit must exist to create imports!");
        }
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        for (String s : this.m_importsToCreate) {
            this.getCompilationUnit().createImport(s, null, monitor);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_icu;
    }

    public boolean addImportToCreate(String imp) {
        return this.m_importsToCreate.add(imp);
    }

    public boolean removeImportToCreate(String imp) {
        return this.m_importsToCreate.remove(imp);
    }

    public void setImportsToCreate(Collection<String> imports) {
        this.m_importsToCreate.clear();
        this.m_importsToCreate.addAll(imports);
    }
}

