/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;

public class NlsEntry
implements INlsEntry {
    private String m_key;
    private Map<Language, String> m_translations;
    private final INlsProject m_project;
    private final ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();

    public NlsEntry(INlsEntry row) {
        this(row, row.getProject());
    }

    public NlsEntry(INlsEntry row, INlsProject project) {
        this.m_project = project;
        this.m_translations = new HashMap<Language, String>();
        this.update(row);
    }

    public NlsEntry(String key, INlsProject project) {
        this.m_translations = new HashMap<Language, String>();
        this.m_project = project;
        this.m_key = key;
    }

    @Override
    public INlsProject getProject() {
        return this.m_project;
    }

    @Override
    public int getType() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NlsEntry other = (NlsEntry)obj;
        try {
            this.m_lock.readLock().lock();
            boolean bl = Objects.equals(this.m_key, other.m_key) && Objects.equals(this.m_translations, other.m_translations) && Objects.equals(this.getType(), other.getType());
            return bl;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public int hashCode() {
        try {
            this.m_lock.readLock().lock();
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_key == null ? 0 : this.m_key.hashCode());
            result = 31 * result + (this.m_translations == null ? 0 : this.m_translations.hashCode());
            int n = result = 31 * result + this.getType();
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public void update(INlsEntry refEntry) {
        try {
            this.m_lock.writeLock().lock();
            Map<Language, String> allTranslations = refEntry.getAllTranslations();
            this.m_translations = new HashMap<Language, String>(allTranslations.size());
            this.m_key = refEntry.getKey();
            for (Map.Entry<Language, String> entry : allTranslations.entrySet()) {
                this.addTranslationInternal(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public String getKey() {
        return this.m_key;
    }

    @Override
    public Map<Language, String> getAllTranslations() {
        try {
            this.m_lock.readLock().lock();
            Map<Language, String> map = Collections.unmodifiableMap(this.m_translations);
            return map;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    protected void addTranslationInternal(Language language, String text) {
        try {
            this.m_lock.writeLock().lock();
            if (text == null || "".equals(text)) {
                text = null;
            }
            this.m_translations.put(language, text);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public void addTranslation(Language language, String text) {
        this.addTranslationInternal(language, text);
    }

    public void removeTranslation(Language language) {
        try {
            this.m_lock.writeLock().lock();
            this.m_translations.remove(language);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public String getTranslation(Language language) {
        return this.getTranslation(language, false);
    }

    @Override
    public String getTranslation(Language language, boolean defaultIfNotExist) {
        try {
            Locale locale;
            this.m_lock.readLock().lock();
            String translation = this.m_translations.get(language);
            if (translation == null && defaultIfNotExist && (translation = this.m_translations.get(new Language(locale = new Locale(language.getLocale().getLanguage(), language.getLocale().getCountry())))) == null && (translation = this.m_translations.get(new Language(locale = new Locale(locale.getLanguage())))) == null && (translation = this.m_translations.get(Language.LANGUAGE_DEFAULT)) == null) {
                translation = "!" + this.getKey() + "!";
            }
            String string = translation;
            return string;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.m_key;
    }

    public void setKey(String key) {
        try {
            this.m_lock.writeLock().lock();
            this.m_key = key;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }
}

