/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.execution.PriorityComparator;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunIAfterClassExtensions
extends AbstractStatementWithScreenshot {
    private static final Logger log = Logger.getLogger(RunIAfterClassExtensions.class);
    private final List<IAfterTest> afters;

    public RunIAfterClassExtensions(String config, Statement next, TestClass testClass, List<IAfterTest> afters) {
        super(config, next, testClass, null, null);
        this.afters = afters;
    }

    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.nextStatement.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        IAfterTest after = null;
        log.debug("Run after class extensions for test class " + this.testClass.getJavaClass().getName());
        this.afters.sort(new PriorityComparator());
        Iterator<IAfterTest> iterator = this.afters.iterator();
        while (iterator.hasNext()) {
            IAfterTest each;
            after = each = iterator.next();
            try {
                if (!after.hasToRun()) continue;
                log.debug("Run method runAfterTestClass() of class " + after.getClass().getCanonicalName());
                after.runAfterTestClass(this.config, this.testClass);
            }
            catch (Throwable e) {
                if (ScreenshotCapturer.shouldCaptureScreenshotOnException(e)) {
                    log.error("Run method runAfterTestClass() of class " + after.getClass().getCanonicalName() + " failed", e);
                    this.createScreenshot("AfterClassExt", after.getClass());
                }
                errors.add(e);
            }
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

