/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.browser;

import org.eclipse.photran.internal.core.vpg.eclipse.EclipseVPG;
import org.eclipse.photran.internal.ui.browser.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

class DependenciesTab {
    private List incomingDependenciesList;
    private List outgoingDependenciesList;
    private Text fileNameTextBox;
    private Text timestampTextBox;

    public DependenciesTab(TabItem dependenciesTab, TabFolder tabfolder) {
        Composite composite = new Composite((Composite)tabfolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createDependentsList(composite);
        this.createFileNameField(composite);
        this.createTimeStampField(composite);
        this.createDependenciesList(composite);
        dependenciesTab.setControl((Control)composite);
    }

    private void createDependentsList(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new FillLayout());
        group.setText(Messages.DependenciesTab_FilesThatDependOnTheSelectedFile);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        this.incomingDependenciesList = new List((Composite)group, 772);
    }

    private void createFileNameField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.DependenciesTab_FileName);
        this.fileNameTextBox = new Text(composite, 2060);
        this.fileNameTextBox.setBounds(100, 100, 100, 100);
        this.fileNameTextBox.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createTimeStampField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.DependenciesTab_TimeStamp);
        this.timestampTextBox = new Text(composite, 2060);
        this.timestampTextBox.setBounds(100, 100, 100, 100);
        this.timestampTextBox.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createDependenciesList(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new FillLayout());
        group.setText(Messages.DependenciesTab_FilesTheSelectedFileDependsOn);
        this.outgoingDependenciesList = new List((Composite)group, 772);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
    }

    public void showDependentsAndDependencies(String filename, EclipseVPG vpg) {
        this.incomingDependenciesList.removeAll();
        this.outgoingDependenciesList.removeAll();
        this.fileNameTextBox.setText(filename);
        for (String dependentFile : vpg.getIncomingDependenciesTo(filename)) {
            this.incomingDependenciesList.add(dependentFile);
        }
        for (String dependentFile : vpg.getOutgoingDependenciesFrom(filename)) {
            this.outgoingDependenciesList.add(dependentFile);
        }
    }
}

