/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.validator;

import java.util.concurrent.CompletableFuture;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;

public class SyntaxValidatorListener
implements IDocumentListener {
    private static final String ERROR_MARKER = "org.eclipse.jdt.ui.error";

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        IDocument fDocument = event.fDocument;
        ITextFileBuffer textFileBuffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(event.getDocument());
        if (textFileBuffer == null) {
            return;
        }
        IAnnotationModel model = textFileBuffer.getAnnotationModel();
        model.getAnnotationIterator().forEachRemaining(annotation -> {
            if (ERROR_MARKER.equals(annotation.getType())) {
                model.removeAnnotation(annotation);
            }
        });
        CompletableFuture.runAsync(() -> {
            try {
                Parser.getDefault().parse(fDocument);
            }
            catch (XMLStreamException e) {
                Annotation error = this.prepareAnnotation(e);
                Position position = this.preparePosition(e);
                model.addAnnotation(error, position);
            }
        });
    }

    private Position preparePosition(XMLStreamException e) {
        int offset = e.getLocation().getCharacterOffset();
        Position position = new Position(offset);
        return position;
    }

    private Annotation prepareAnnotation(XMLStreamException e) {
        Annotation annotation = new Annotation(ERROR_MARKER, true, this.beautify(e.getLocalizedMessage()));
        return annotation;
    }

    private String beautify(String localizedMessage) {
        String startOfInterest = "Message:";
        int colonIndex = localizedMessage.indexOf(startOfInterest);
        return localizedMessage.substring(colonIndex + startOfInterest.length());
    }
}

