/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.UMLPackage;

class InteractionContainerDeletionContext {
    private static String PARAMETER_NAME = "papyrus.uml.InteractionContainerDeletionContext";
    private final Set<InteractionFragment> interactionContainersBeingDestroyed = new HashSet<InteractionFragment>();
    private final Map<InteractionFragment, Integer> insertionIndexByContainer = new HashMap<InteractionFragment, Integer>();
    private final TransactionalEditingDomain domain;

    private InteractionContainerDeletionContext(DestroyRequest request) {
        this.domain = request.getEditingDomain();
        request.setParameter(PARAMETER_NAME, (Object)this);
    }

    static Optional<InteractionContainerDeletionContext> get(DestroyElementRequest request) {
        return InteractionContainerDeletionContext.get((DestroyRequest)request, request.getElementToDestroy());
    }

    static Optional<InteractionContainerDeletionContext> get(DestroyDependentsRequest request) {
        return InteractionContainerDeletionContext.get((DestroyRequest)request, request.getElementToDestroy());
    }

    private static Optional<InteractionContainerDeletionContext> get(DestroyRequest request, EObject elementToDestroy) {
        Optional<InteractionContainerDeletionContext> result = Optional.ofNullable(request.getParameter(PARAMETER_NAME)).filter(InteractionContainerDeletionContext.class::isInstance).map(InteractionContainerDeletionContext.class::cast);
        if (InteractionContainerDeletionContext.isInteractionContainer(elementToDestroy)) {
            if (!result.isPresent()) {
                result = Optional.of(new InteractionContainerDeletionContext(request));
            }
            result.get().add(elementToDestroy);
        }
        return result;
    }

    static void deleting(DestroyElementRequest request) {
        if (InteractionContainerDeletionContext.isInteractionContainer(request.getElementToDestroy())) {
            InteractionContainerDeletionContext.get(request);
        }
    }

    private static boolean isInteractionContainer(EObject object) {
        return object instanceof InteractionOperand || object instanceof CombinedFragment || object instanceof Interaction;
    }

    private void add(EObject elementToDestroy) {
        this.interactionContainersBeingDestroyed.add((InteractionFragment)elementToDestroy);
    }

    boolean isBeingDestroyed(Interaction interaction) {
        return this.interactionContainersBeingDestroyed.contains(interaction);
    }

    boolean isBeingDestroyed(CombinedFragment combinedFragment) {
        return this.interactionContainersBeingDestroyed.contains(combinedFragment);
    }

    boolean isBeingDestroyed(InteractionOperand operand) {
        return this.interactionContainersBeingDestroyed.contains(operand);
    }

    InteractionFragment getNewContainerFor(InteractionFragment fragment) {
        return fragment instanceof InteractionOperand ? null : this.doGetNewContainerFor((Element)fragment);
    }

    InteractionFragment getNewContainerFor(GeneralOrdering generalOrdering) {
        return this.doGetNewContainerFor((Element)generalOrdering);
    }

    private InteractionFragment doGetNewContainerFor(Element element) {
        InteractionFragment owner = (InteractionFragment)element.getOwner();
        if (owner instanceof InteractionOperand && !this.isBeingDestroyed((InteractionOperand)owner)) {
            return null;
        }
        if (owner instanceof Interaction && !this.isBeingDestroyed((Interaction)owner)) {
            return null;
        }
        InteractionFragment result = null;
        while (result == null && owner != null) {
            if (owner instanceof InteractionOperand && !this.isBeingDestroyed((InteractionOperand)owner)) {
                result = owner;
            } else if (owner instanceof Interaction) {
                if (this.isBeingDestroyed((Interaction)owner)) break;
                result = owner;
                break;
            }
            owner = (InteractionFragment)owner.getOwner();
        }
        return result;
    }

    ICommand getDestroyCommand(InteractionFragment fragment) {
        InteractionFragment container = this.getNewContainerFor(fragment);
        return container != null ? this.move(fragment, container) : null;
    }

    ICommand move(InteractionFragment fragment, InteractionFragment into) {
        Integer insertionIndex = this.insertionIndexByContainer.get(into);
        if (insertionIndex == null) {
            CombinedFragment nearestCF = null;
            InteractionFragment owner = (InteractionFragment)fragment.getOwner();
            while (nearestCF == null && owner != null && !(owner instanceof Interaction)) {
                CombinedFragment cf;
                if (owner instanceof CombinedFragment && !this.isBeingDestroyed(cf = (CombinedFragment)owner)) {
                    nearestCF = cf;
                }
                owner = (InteractionFragment)owner.getOwner();
            }
            if (nearestCF != null && into == nearestCF.getOwner()) {
                EList fragments = nearestCF.getEnclosingOperand() != null ? nearestCF.getEnclosingOperand().getFragments() : nearestCF.getEnclosingInteraction().getFragments();
                insertionIndex = fragments.indexOf(nearestCF) + 1;
                this.insertionIndexByContainer.put(into, insertionIndex);
            }
        }
        int index = -1;
        if (insertionIndex != null) {
            index = insertionIndex;
            this.insertionIndexByContainer.put(into, index + 1);
        }
        EReference containment = into instanceof InteractionOperand ? UMLPackage.Literals.INTERACTION_OPERAND__FRAGMENT : UMLPackage.Literals.INTERACTION__FRAGMENT;
        return this.move(fragment, into, containment, index);
    }

    ICommand getDestroyCommand(GeneralOrdering generalOrdering) {
        InteractionFragment container = this.getNewContainerFor(generalOrdering);
        return container != null ? this.move(generalOrdering, container) : null;
    }

    ICommand move(GeneralOrdering generalOrdering, InteractionFragment into) {
        return this.move(generalOrdering, into, UMLPackage.Literals.INTERACTION_FRAGMENT__GENERAL_ORDERING, -1);
    }

    <E extends Element> ICommand move(final E element, final InteractionFragment into, final EReference containment, final int index) {
        return new AbstractTransactionalCommand(this.domain, "Move Interaction Element", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EList list = (EList)into.eGet((EStructuralFeature)containment);
                if (index < 0) {
                    list.add((Object)element);
                } else {
                    if (list.size() < index) {
                        return CommandResult.newErrorCommandResult((String)("index out of bounds: " + index));
                    }
                    list.add(index, (Object)element);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }
}

