/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.ClassifierEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ConstrainedItemBorderLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.DataTypeFigure;
import org.eclipse.papyrus.uml.diagram.profile.custom.policies.CustomGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.DataTypeAttributeCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.DataTypeNameEditPart;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.DataTypeOperationCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Color;

public class DataTypeEditPart
extends ClassifierEditPart {
    public static final String VISUAL_ID = "DataType_Shape";
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public DataTypeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new DefaultCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DefaultGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("RESIZE_BORDER_ITEMS", (EditPolicy)new ConstrainedItemBorderLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new CustomGraphicalNodeEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new DataTypeFigure();
        return this.primaryShape;
    }

    public DataTypeFigure getPrimaryShape() {
        return (DataTypeFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof DataTypeNameEditPart) {
            ((DataTypeNameEditPart)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof DataTypeAttributeCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getAttributeCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((DataTypeAttributeCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof DataTypeOperationCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getOperationCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((DataTypeOperationCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof DataTypeNameEditPart) {
            return true;
        }
        if (childEditPart instanceof DataTypeAttributeCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getAttributeCompartmentFigure();
            pane.remove(((DataTypeAttributeCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof DataTypeOperationCompartmentEditPart) {
            IFigure pane = this.getPrimaryShape().getOperationCompartmentFigure();
            pane.remove(((DataTypeOperationCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof DataTypeAttributeCompartmentEditPart) {
            return this.getPrimaryShape().getAttributeCompartmentFigure();
        }
        if (editPart instanceof DataTypeOperationCompartmentEditPart) {
            return this.getPrimaryShape().getOperationCompartmentFigure();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(100, 100);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType("DataType_NameLabel"));
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateViewAndElementRequest) {
            CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter();
            IElementType type = (IElementType)adapter.getAdapter(IElementType.class);
            if (UMLElementTypes.isKindOf(type, UMLElementTypes.Property_DataTypeAttributeLabel)) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType("DataType_AttributeCompartment"));
            }
            if (UMLElementTypes.isKindOf(type, UMLElementTypes.Operation_DataTypeOperationLabel)) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType("DataType_OperationCompartment"));
            }
        }
        return super.getTargetEditPart(request);
    }
}

