/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.objectteams.otdt.internal.ui.preferences.CompilerConfigurationBlock;
import org.eclipse.objectteams.otdt.internal.ui.preferences.OTPreferencesMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class OTCompilerPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.eclipse.objectteams.otdt.ui.preferences.CompilerPreferencePage";
    public static final String PROP_ID = "org.eclipse.objectteams.otdt.ui.propertyPages.CompilerPreferencePage";
    private CompilerConfigurationBlock fConfigurationBlock;

    public OTCompilerPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setTitle(OTPreferencesMessages.OTCompilerPreferencePage_title);
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.fConfigurationBlock = new CompilerConfigurationBlock(this.getNewStatusChangedListener(), this.getProject(), container);
        super.createControl(parent);
        if (this.isProjectPreferencePage()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.compiler_property_page_context");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.compiler_preference_page_context");
        }
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fConfigurationBlock.createContents(composite);
    }

    public Point computeSize() {
        Point size = super.computeSize();
        size.y = 10;
        return size;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.fConfigurationBlock.hasProjectSpecificOptions(project);
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    public void dispose() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.dispose();
        }
        super.dispose();
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.enablePreferenceContent(enable);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        if (this.fConfigurationBlock != null && !this.fConfigurationBlock.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performApply();
        }
    }

    public void applyData(Object data) {
        super.applyData(data);
        if (data instanceof Map && this.fConfigurationBlock != null) {
            Boolean useProjectOptions;
            Map map = (Map)data;
            if (this.isProjectPreferencePage() && (useProjectOptions = (Boolean)map.get("use_project_specific_key")) != null) {
                this.enableProjectSpecificSettings(useProjectOptions);
            }
            Object key = map.get("select_option_key");
            Object qualifier = map.get("select_option_qualifier");
            if (key instanceof String && qualifier instanceof String) {
                this.fConfigurationBlock.selectOption((String)key, (String)qualifier);
            }
        }
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }
}

