/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.util.ui.internal.exported.handler.HandlerUtils;
import org.eclipse.modisco.infra.browser.editor.ui.ITreeEditor;
import org.eclipse.modisco.infra.browser.editor.ui.ITreeEditorOpener;
import org.eclipse.modisco.infra.browser.editor.ui.exceptions.TreeEditorOpenerException;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.TreeEditor;
import org.eclipse.modisco.infra.browser.editor.ui.internal.opener.ResourceEditorInput;
import org.eclipse.modisco.infra.browser.editor.ui.internal.opener.ResourceSetEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class TreeEditorOpener
implements ITreeEditorOpener {
    private static TreeEditor openEditor(final IEditorInput editorInput) throws TreeEditorOpenerException {
        final TreeEditor[] editor = new TreeEditor[1];
        final PartInitException[] exception = new PartInitException[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = HandlerUtils.getActivePage();
                if (activePage != null) {
                    try {
                        editor[0] = (TreeEditor)activePage.openEditor(editorInput, TreeEditor.getEditorId());
                    }
                    catch (PartInitException e) {
                        exception[0] = e;
                    }
                }
            }
        });
        if (exception[0] != null) {
            throw new TreeEditorOpenerException(exception[0]);
        }
        return editor[0];
    }

    public ITreeEditor openWithEObject(EObject eObject) throws TreeEditorOpenerException {
        Resource resource = eObject.eResource();
        return this.openWithResource(resource);
    }

    public ITreeEditor openWithResource(Resource resource) throws TreeEditorOpenerException {
        ResourceEditorInput editorInput = new ResourceEditorInput(resource);
        return TreeEditorOpener.openEditor(editorInput);
    }

    public ITreeEditor openWithResourceSet(ResourceSet resourceSet) throws TreeEditorOpenerException {
        ResourceSetEditorInput editorInput = new ResourceSetEditorInput(resourceSet);
        return TreeEditorOpener.openEditor(editorInput);
    }
}

