/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.File;
import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.ibmvm.agent.DumpAgent;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;

@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/acquiringheapdump.html#task_acquiringheapdump__2")
public class IBMVmInfo
extends VmInfo {
    @Argument
    public DumpType type = DumpType.SYSTEM;
    @Argument(isMandatory=false)
    public boolean live = false;
    @Argument
    public boolean compress = false;
    @Argument(isMandatory=false, advice=Argument.Advice.DIRECTORY)
    public File dumpdir;
    private String pid;

    IBMVmInfo(String pid, String description, boolean heapDumpEnabled, String proposedFileName, IHeapDumpProvider heapDumpProvider) {
        super(0, description, heapDumpEnabled, proposedFileName, heapDumpProvider);
        this.setPid(pid);
    }

    void setPid(String s) {
        this.pid = s;
        try {
            int i = Integer.parseInt(s.split("\\.")[0]);
            this.setPid(i);
        }
        catch (NumberFormatException e) {
            this.setPid(-1);
        }
    }

    String getPidName() {
        return this.pid;
    }

    String agentCommand(File f) {
        String fn = f == null ? this.getProposedFileName() : f.getAbsolutePath();
        if (this.type == DumpType.SYSTEM) {
            return "system" + DumpAgent.INFO_SEPARATOR + Boolean.toString(this.live) + DumpAgent.INFO_SEPARATOR + fn;
        }
        if (this.type == DumpType.HEAP) {
            return "heap+java" + DumpAgent.INFO_SEPARATOR + Boolean.toString(this.live) + DumpAgent.INFO_SEPARATOR + fn;
        }
        if (this.type == DumpType.JAVA) {
            return "java" + DumpAgent.INFO_SEPARATOR + Boolean.toString(this.live) + DumpAgent.INFO_SEPARATOR + fn;
        }
        if (this.type == DumpType.HPROF) {
            return "hprof" + DumpAgent.INFO_SEPARATOR + Boolean.toString(this.live) + DumpAgent.INFO_SEPARATOR + fn;
        }
        return null;
    }

    public String getProposedFileName() {
        String ret = super.getProposedFileName();
        if (ret == null) {
            BaseProvider provider = (BaseProvider)this.getHeapDumpProvider();
            if (this.type == DumpType.SYSTEM) {
                ret = this.compress ? provider.systemDumpZipTemplate : provider.systemDumpTemplate;
            } else if (this.type == DumpType.HEAP) {
                ret = this.compress ? provider.heapDumpZipTemplate : provider.heapDumpTemplate;
            } else if (this.type == DumpType.JAVA) {
                ret = provider.javaDumpTemplate;
            } else if (this.type == DumpType.HPROF) {
                ret = provider.hprofDumpTemplate;
            }
        }
        return ret;
    }
}

