/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.facets;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.facets.AbstractFacetDetector;
import org.eclipse.m2e.wtp.facets.FacetDetectorExtensionReader;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetDetectorManager {
    private static final Logger LOG = LoggerFactory.getLogger(FacetDetectorManager.class);
    private static final FacetDetectorManager instance = new FacetDetectorManager();
    private Map<String, List<AbstractFacetDetector>> facetDetectors = null;

    private FacetDetectorManager() {
    }

    public static FacetDetectorManager getInstance() {
        return instance;
    }

    public IProjectFacetVersion findFacetVersion(IMavenProjectFacade mavenProjectFacade, String facetId, IProgressMonitor monitor) throws CoreException {
        return this.findFacetVersion(mavenProjectFacade, facetId, null, monitor);
    }

    public IProjectFacetVersion findFacetVersion(IMavenProjectFacade mavenProjectFacade, String facetId, Map<?, ?> context, IProgressMonitor monitor) throws CoreException {
        if (facetId == null) {
            return null;
        }
        List<AbstractFacetDetector> detectors = this.getFacetDetectors().get(facetId);
        if (detectors == null || detectors.isEmpty()) {
            return null;
        }
        IProjectFacetVersion version = null;
        for (AbstractFacetDetector detector : detectors) {
            if (monitor != null && monitor.isCanceled()) break;
            try {
                version = detector.findFacetVersion(mavenProjectFacade, context, monitor);
                if (version == null) continue;
                facetId.equals(version.getProjectFacet().getId());
                break;
            }
            catch (CoreException ce) {
                LOG.error(ce.getLocalizedMessage());
            }
        }
        return version;
    }

    private Map<String, List<AbstractFacetDetector>> getFacetDetectors() {
        if (this.facetDetectors == null) {
            this.facetDetectors = FacetDetectorExtensionReader.readFacetDetectorExtensions();
        }
        return this.facetDetectors;
    }
}

