/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CNFOutlinePage
implements IContentOutlinePage,
ILabelProviderListener {
    public static final String ID = "org.eclipse.lsp4e.outline";
    public static final String LINK_WITH_EDITOR_PREFERENCE = "org.eclipse.lsp4e.outline.linkWithEditor";
    public static final String SHOW_KIND_PREFERENCE = "org.eclipse.lsp4e.outline.showKind";
    private CommonViewer viewer;
    private IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
    private LanguageServiceAccessor.LSPDocumentInfo info;
    private ITextEditor textEditor;
    private ITextViewer textEditorViewer;
    private EditorSelectionChangedListener editorSelectionChangedListener;

    public CNFOutlinePage(LanguageServiceAccessor.LSPDocumentInfo info, @Nullable ITextEditor textEditor) {
        this.textEditor = textEditor;
        this.info = info;
    }

    public void createControl(Composite parent) {
        this.viewer = new CommonViewer(ID, parent, 0);
        this.viewer.setInput((Object)new OutlineInfo(this.info, this.textEditor));
        this.viewer.getLabelProvider().addListener((ILabelProviderListener)this);
        if (this.textEditor != null) {
            this.viewer.addOpenListener(event -> {
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true)) {
                    this.textEditor.setFocus();
                }
            });
            if (this.textEditor instanceof AbstractTextEditor) {
                AbstractTextEditor editor = (AbstractTextEditor)this.textEditor;
                this.textEditorViewer = (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
            } else {
                this.textEditorViewer = null;
            }
            this.viewer.addSelectionChangedListener(event -> {
                Object selection;
                Range range;
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true) && this.viewer.getTree().isFocusControl() && this.viewer.getSelection() != null && (range = this.getRangeSelection(selection = ((TreeSelection)this.viewer.getSelection()).getFirstElement())) != null) {
                    try {
                        int startOffset = this.info.getDocument().getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                        int endOffset = this.info.getDocument().getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
                        this.textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                    catch (BadLocationException e) {
                        return;
                    }
                }
            });
            if (this.textEditorViewer != null) {
                this.editorSelectionChangedListener = new EditorSelectionChangedListener();
                this.editorSelectionChangedListener.install(this.textEditorViewer.getSelectionProvider());
            }
        }
    }

    private Range getRangeSelection(Object selection) {
        if (selection == null) {
            return null;
        }
        if (selection instanceof SymbolInformation) {
            return ((SymbolInformation)selection).getLocation().getRange();
        }
        if (selection instanceof SymbolsModel.DocumentSymbolWithFile) {
            return ((SymbolsModel.DocumentSymbolWithFile)selection).symbol.getSelectionRange();
        }
        return null;
    }

    public static void refreshTreeSelection(TreeViewer viewer, int offset, IDocument document) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        Object[] objects = contentProvider.getElements(null);
        SymbolInformation bestSymbol = null;
        int level = 0;
        while (objects != null && objects.length > 0) {
            SymbolInformation nextChild = null;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                SymbolInformation symbol;
                Object object = objectArray[n2];
                SymbolInformation symbolInformation = symbol = object instanceof SymbolInformation ? (SymbolInformation)object : (SymbolInformation)Adapters.adapt((Object)object, SymbolInformation.class);
                if (symbol != null && CNFOutlinePage.isOffsetInSymbolRange(offset, symbol, document)) {
                    nextChild = symbol;
                    objects = contentProvider.getChildren((Object)symbol);
                    break;
                }
                ++n2;
            }
            if (nextChild == null) break;
            ++level;
            bestSymbol = nextChild;
        }
        if (bestSymbol != null) {
            if (bestSymbol.equals(viewer.getStructuredSelection().getFirstElement())) {
                return;
            }
            int finalLevel = level;
            SymbolInformation finalBestSymbol = bestSymbol;
            Display.getDefault().asyncExec(() -> {
                viewer.expandToLevel(finalLevel);
                viewer.setSelection((ISelection)new StructuredSelection((Object)finalBestSymbol), true);
            });
        }
    }

    private static boolean isOffsetInSymbolRange(int offset, SymbolInformation symbol, IDocument document) {
        Range range = symbol.getLocation().getRange();
        try {
            int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
            int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
            return startOffset <= offset && endOffset >= offset;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public void dispose() {
        this.viewer.dispose();
        if (this.textEditorViewer != null) {
            this.editorSelectionChangedListener.uninstall(this.textEditorViewer.getSelectionProvider());
        }
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.viewer.refresh(true);
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof ITextSelection)) {
                return;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            if (!CNFOutlinePage.this.preferences.getBoolean(CNFOutlinePage.LINK_WITH_EDITOR_PREFERENCE, true)) {
                return;
            }
            int offset = CNFOutlinePage.this.viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)CNFOutlinePage.this.viewer).widgetOffset2ModelOffset(textSelection.getOffset()) : textSelection.getOffset();
            CNFOutlinePage.refreshTreeSelection((TreeViewer)CNFOutlinePage.this.viewer, offset, CNFOutlinePage.this.info.getDocument());
        }
    }

    class OutlineInfo {
        public final LanguageServiceAccessor.LSPDocumentInfo info;
        public final ITextEditor textEditor;

        public OutlineInfo( @Nullable LanguageServiceAccessor.LSPDocumentInfo info, ITextEditor textEditor) {
            this.info = info;
            this.textEditor = textEditor;
        }
    }
}

