/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DockerComposeUpDialog
extends Dialog {
    private final DockerComposeUpModel model = new DockerComposeUpModel();
    private final DataBindingContext dbc = new DataBindingContext();

    public DockerComposeUpDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText(WizardMessages.getString("DockerComposeUpDialog.title"));
    }

    protected Point getInitialSize() {
        return new Point(400, super.getInitialSize().y);
    }

    protected Control createDialogArea(Composite parent) {
        int COLUMNS = 2;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(WizardMessages.getString("DockerComposeUpDialog.explanationLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)explanationLabel);
        Label containerLabel = new Label(container, 0);
        containerLabel.setText(WizardMessages.getString("DockerComposeUpDialog.connectionLabel"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)containerLabel);
        Combo containerSelectionCombo = new Combo(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerSelectionCombo);
        ComboViewer connectionSelectionComboViewer = new ComboViewer(containerSelectionCombo);
        connectionSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        List<String> connectionNames = this.model.getConnectionNames();
        connectionSelectionComboViewer.setInput(connectionNames);
        new ContentProposalAdapter((Control)containerSelectionCombo, (IControlContentAdapter)new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Combo combo = (Combo)control;
                Point selection = combo.getSelection();
                combo.setText(text);
                selection.y = selection.x = text.length();
                combo.setSelection(selection);
            }
        }, this.getConnectionNameContentProposalProvider(containerSelectionCombo), null, null);
        ISWTObservableValue connnectionNameObservable = WidgetProperties.selection().observe((Widget)connectionSelectionComboViewer.getCombo());
        if (!connectionNames.isEmpty()) {
            this.model.setConnectionName(connectionNames.get(0));
        }
        Composite errorContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).applyTo((Control)errorContainer);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(errorContainer);
        Label errorMessageIcon = new Label(errorContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(20, -1).applyTo((Control)errorMessageIcon);
        Label errorMessageLabel = new Label(errorContainer, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)errorMessageLabel);
        this.dbc.bindValue((IObservableValue)connnectionNameObservable, BeanProperties.value(DockerComposeUpModel.class, (String)"connectionName").observe((Object)this.model));
        this.setupValidationSupport(errorMessageIcon, errorMessageLabel);
        return container;
    }

    private void setupValidationSupport(Label errorMessageIcon, Label errorMessageLabel) {
        for (Binding binding : this.dbc.getBindings()) {
            binding.getModel().addChangeListener(this.onSettingsChanged(errorMessageIcon, errorMessageLabel));
        }
    }

    private IChangeListener onSettingsChanged(Label errorMessageIcon, Label errorMessageLabel) {
        return event -> {
            IStatus status = this.validateInput();
            if (Display.getCurrent() == null) {
                return;
            }
            Display.getCurrent().syncExec(() -> {
                if (status.isOK()) {
                    errorMessageIcon.setVisible(false);
                    errorMessageLabel.setVisible(false);
                    this.setOkButtonEnabled(true);
                } else if (status.matches(2)) {
                    errorMessageIcon.setVisible(true);
                    errorMessageIcon.setImage(SWTImagesFactory.DESC_WARNING.createImage());
                    errorMessageLabel.setVisible(true);
                    errorMessageLabel.setText(status.getMessage());
                    this.setOkButtonEnabled(true);
                } else if (status.matches(4)) {
                    if (status.getMessage() != null && !status.getMessage().isEmpty()) {
                        errorMessageIcon.setVisible(true);
                        errorMessageIcon.setImage(SWTImagesFactory.DESC_ERROR.createImage());
                        errorMessageLabel.setVisible(true);
                        errorMessageLabel.setText(status.getMessage());
                    }
                    this.setOkButtonEnabled(false);
                }
            });
        };
    }

    private IStatus validateInput() {
        String selectedConnectionName = this.model.getConnectionName();
        if (selectedConnectionName == null || selectedConnectionName.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.model.getConnectionNames().contains(selectedConnectionName)) {
            return ValidationStatus.error((String)WizardMessages.getFormattedString("DockerComposeUpDialog.error.unknownConnection", selectedConnectionName));
        }
        return Status.OK_STATUS;
    }

    public IDockerConnection getSelectedConnection() {
        return DockerConnectionManager.getInstance().findConnection(this.model.connectionName);
    }

    private IContentProposalProvider getConnectionNameContentProposalProvider(Combo connectionNamesSelectionCombo) {
        return (contents, position) -> {
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            String[] stringArray = connectionNamesSelectionCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String connectionName = stringArray[n2];
                if (connectionName.contains(contents)) {
                    proposals.add(new ContentProposal(connectionName, connectionName, connectionName, position));
                }
                ++n2;
            }
            return proposals.toArray(new IContentProposal[0]);
        };
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    class DockerComposeUpModel
    extends BaseDatabindingModel {
        public static final String CONNECTION_NAME = "connectionName";
        private String connectionName;
        private final List<String> connectionNames = DockerConnectionManager.getInstance().getConnectionNames();

        DockerComposeUpModel() {
        }

        public List<String> getConnectionNames() {
            return this.connectionNames;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
            this.firePropertyChange(CONNECTION_NAME, this.connectionName, this.connectionName);
        }
    }
}

