/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.debug.ui.internal;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariableWrapper;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ldt.debug.core.internal.LuaCoroutine;
import org.eclipse.ldt.debug.core.internal.LuaModuleURIUtil;
import org.eclipse.ldt.debug.core.internal.UnreachableStackFrame;
import org.eclipse.ldt.debug.ui.internal.Activator;
import org.eclipse.ldt.debug.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class LuaDebugModelPresentation
extends ScriptDebugModelPresentation {
    public String getEditorId(IEditorInput input, Object element) {
        return "org.eclipse.ldt.ui.editor";
    }

    protected Image getStackFrameImage(IScriptStackFrame stackFrame) {
        UnreachableStackFrame uStackFrame = UnreachableStackFrame.checkReachable((IScriptStackFrame)stackFrame);
        if (uStackFrame != null) {
            ImageRegistry reg = Activator.getDefault().getImageRegistry();
            if (uStackFrame.getReason().equals("ccode")) {
                return reg.get("icons/obj16/stckframe_ccode.gif");
            }
            return reg.get("icons/obj16/stckframe_unreachable.gif");
        }
        return super.getStackFrameImage(stackFrame);
    }

    protected String getStackFrameText(IScriptStackFrame stackFrame) {
        String sourceLine = this.getSourceLine(stackFrame);
        String sourceLocation = this.getSourceLocation(stackFrame);
        return MessageFormat.format("{0}  [ {1} ]", sourceLine, sourceLocation);
    }

    private String getSourceLocation(IScriptStackFrame stackFrame) {
        String location;
        URI sourceURI = stackFrame.getSourceURI();
        if ("file".equalsIgnoreCase(sourceURI.getScheme())) {
            IPath path;
            try {
                path = LuaDebugModelPresentation.getStackFrameRelativePath((IScriptStackFrame)stackFrame);
            }
            catch (CoreException e) {
                Activator.logWarning("unable to extract relative path", e);
                path = new Path(sourceURI.getPath());
            }
            location = path.toString();
        } else if (LuaModuleURIUtil.isModuleURI((URI)sourceURI).booleanValue()) {
            location = LuaModuleURIUtil.getModuleName((URI)sourceURI);
        } else if ("ccode".equalsIgnoreCase(sourceURI.getScheme())) {
            location = Messages.LuaDebugModelPresentation_ccode;
        } else if ("tailreturn".equalsIgnoreCase(sourceURI.getScheme())) {
            location = Messages.LuaDebugModelPresentation_tail_return;
        } else if ("unknown".equalsIgnoreCase(sourceURI.getScheme())) {
            location = Messages.LuaDebugModelPresentation_unknown;
        } else {
            location = Messages.LuaDebugModelPresentation_unknown;
            Activator.logWarning("unsupported uri :" + sourceURI);
        }
        int lineNumber = -1;
        try {
            lineNumber = stackFrame.getLineNumber();
        }
        catch (DebugException e) {
            Activator.logWarning("could not acces to stackframe line number for  + sourceURI");
        }
        if (lineNumber > 0) {
            return MessageFormat.format("{0}:{1}", location, lineNumber);
        }
        return location;
    }

    private String getSourceLine(IScriptStackFrame stackFrame) {
        ISourceModuleDocumentProvider provider;
        IDocument document;
        Object object;
        ILaunch launch;
        ISourceLocator sourceLocator;
        String sourceLine = stackFrame.getSourceLine();
        if ((sourceLine == null || sourceLine.length() == 0) && (sourceLocator = (launch = stackFrame.getLaunch()).getSourceLocator()) != null && (object = sourceLocator.getSourceElement((IStackFrame)stackFrame)) instanceof IFile && (document = (provider = DLTKUIPlugin.getDocumentProvider()).getDocument((Object)new FileEditorInput((IFile)object))) != null) {
            try {
                sourceLine = LuaDebugModelPresentation.retrieveStackFrameLine(stackFrame, document);
            }
            catch (BadLocationException e) {
                Activator.logWarning("unnable to retrieve stack frame line", e);
            }
            catch (DebugException e) {
                Activator.logWarning("unnable to retrieve stack frame line", e);
            }
        }
        if (sourceLine == null || sourceLine.length() == 0) {
            int level = stackFrame.getStack().size() - stackFrame.getLevel() - 1;
            sourceLine = NLS.bind((String)"Stack frame #{0}", (Object)level);
        }
        if (sourceLine == null || sourceLine.length() == 0) {
            return "";
        }
        return sourceLine;
    }

    private static String retrieveStackFrameLine(IScriptStackFrame frame, IDocument document) throws BadLocationException, DebugException {
        if (frame.getBeginLine() > 0 && frame.getEndLine() > 0) {
            IRegion region = document.getLineInformation(frame.getBeginLine() - 1);
            int start = region.getOffset() + frame.getBeginColumn();
            int len = frame.getBeginLine() == frame.getEndLine() ? frame.getEndColumn() - frame.getBeginColumn() + 1 : region.getLength() - frame.getBeginColumn();
            return document.get(start, len).trim();
        }
        IRegion region = document.getLineInformation(frame.getLineNumber() - 1);
        return document.get(region.getOffset(), region.getLength()).trim();
    }

    public String getVariableName(IVariable variable) throws DebugException {
        if (variable instanceof ScriptVariableWrapper && variable.getName().equals(org.eclipse.dltk.internal.debug.core.model.Messages.ScriptStackFrame_classVariables)) {
            return Messages.LuaDebugModelPresentation_upvalues;
        }
        return super.getVariableName(variable);
    }

    protected Image getVariableImage(IScriptVariable variable) {
        try {
            if (variable.getReferenceTypeName().equals("special")) {
                return Activator.getDefault().getImageRegistry().get("icons/obj16/specialfield_obj.gif");
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return super.getVariableImage(variable);
    }

    protected String getThreadText(IScriptThread thread) {
        if (thread instanceof LuaCoroutine) {
            try {
                return NLS.bind((String)Messages.LuaDebugModelPresentation_pause_coroutine, (Object)thread.getName());
            }
            catch (DebugException e) {
                Activator.logError("Cannot get name of coroutine", e);
            }
        }
        return NLS.bind((String)Messages.LuaDebugModelPresentation_running_coroutine, (Object)(thread.isSuspended() ? "suspended" : "running"));
    }
}

