/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we_view_editor.wizards;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we_view_editor.PluginProperties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewViewWizardPage
extends WizardPage {
    private Text containerText;
    private Text viewnameText;
    private Text fileText;
    private ISelection selection;
    private GridData gd;
    private Composite container;

    public NewViewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(PluginProperties.newWizard_pageTitle);
        this.setDescription(PluginProperties.newWizard_wizardDescription);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Label label;
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        if (Platform.getProduct().getName() == null || !Platform.getProduct().getName().toLowerCase().contains("agilpro")) {
            label = new Label(this.container, 0);
            label.setText(PluginProperties.newWizard_project);
            this.containerText = new Text(this.container, 2052);
            this.gd = new GridData(768);
            this.containerText.setLayoutData((Object)this.gd);
            this.containerText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewViewWizardPage.this.dialogChanged();
                }
            });
            Button button = new Button(this.container, 8);
            button.setText(PluginProperties.newWizard_browse);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewViewWizardPage.this.handleBrowse();
                }
            });
        }
        label = new Label(this.container, 0);
        label.setText(PluginProperties.newWizard_fileName);
        this.fileText = new Text(this.container, 2052);
        this.gd = new GridData(768);
        this.fileText.setLayoutData((Object)this.gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewWizardPage.this.dialogChanged();
            }
        });
        Label placeHolder = new Label(this.container, 0);
        placeHolder.setText(" ");
        Label labelViewname = new Label(this.container, 0);
        labelViewname.setText(PluginProperties.newWizard_viewName);
        this.viewnameText = new Text(this.container, 2052);
        this.viewnameText.setLayoutData((Object)this.gd);
        this.viewnameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewViewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)this.container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && this.containerText != null) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.fileText.setText(String.valueOf(PluginProperties.newWizard_newFile_fileName) + "." + PluginProperties.plugin_view_extension);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, PluginProperties.newWizard_selectProject);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0 && this.containerText != null) {
            this.updateStatus(PluginProperties.newWizard_error_unspecifiedProject);
            return;
        }
        if (container == null || (container.getType() & 6) == 0 && this.containerText != null) {
            this.updateStatus(PluginProperties.newWizard_error_notExistingProject);
            return;
        }
        if (!container.isAccessible() && this.containerText != null) {
            this.updateStatus(PluginProperties.newWizard_error_notWritableProject);
            return;
        }
        File tempFile = new File(container.getLocation() + "\\" + this.getFileName());
        if (tempFile.exists()) {
            this.updateStatus(String.valueOf(this.getFileName()) + " " + PluginProperties.newWizard_error_existingFile);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(PluginProperties.newWizard_error_unspecifiedFileName);
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0 && this.containerText != null) {
            this.updateStatus(PluginProperties.newWizard_error_notValidFileName);
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("view")) {
            this.updateStatus(String.valueOf(PluginProperties.newWizard_error_wrongFileExtension) + "\"view\"");
            return;
        }
        if (this.getViewnameText().length() == 0) {
            this.updateStatus(PluginProperties.newWizard_error_noViewNameSet);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        if (this.containerText != null) {
            return this.containerText.getText();
        }
        return "";
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getViewnameText() {
        return this.viewnameText.getText();
    }
}

