/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.view.pages;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.FontUtil;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;

public class CreateViewConfWizardPage
extends WizardPage {
    static final Logger logger = Logger.getLogger(CreateViewConfWizardPage.class);
    private Combo algorithmCombo;
    private String[] layoutIDs = new String[]{"HorizontalTreeLayoutAlgorithm", "TreeLayoutAlgorithm", "RadialLayoutAlgorithm", "SpringLayoutAlgorithm", "HorizontalShift", "HorizontalLayoutAlgorithm", "VerticalLayoutAlgorithm"};

    public CreateViewConfWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    public Class getSelectedLayoutClass() {
        String selectedLayoutID = this.algorithmCombo.getData(this.algorithmCombo.getText()).toString();
        if (selectedLayoutID.equals("HorizontalTreeLayoutAlgorithm")) {
            return HorizontalTreeLayoutAlgorithm.class;
        }
        if (selectedLayoutID.equals("TreeLayoutAlgorithm")) {
            return TreeLayoutAlgorithm.class;
        }
        if (selectedLayoutID.equals("RadialLayoutAlgorithm")) {
            return RadialLayoutAlgorithm.class;
        }
        if (selectedLayoutID.equals("SpringLayoutAlgorithm")) {
            return SpringLayoutAlgorithm.class;
        }
        if (selectedLayoutID.equals("HorizontalShift")) {
            return HorizontalShift.class;
        }
        if (selectedLayoutID.equals("HorizontalLayoutAlgorithm")) {
            return HorizontalLayoutAlgorithm.class;
        }
        if (selectedLayoutID.equals("VerticalLayoutAlgorithm")) {
            return VerticalLayoutAlgorithm.class;
        }
        return null;
    }

    private String getLayoutName(String layoutID) {
        String layoutName = PluginProperties.getString("wizards_ViewConfAlgorithm_" + layoutID.replace("LayoutAlgorithm", "") + "_name");
        if (layoutName == null || layoutName.equals("")) {
            return layoutID;
        }
        return layoutName;
    }

    private String getLayoutDescription(String layoutID) {
        String layoutDesc = PluginProperties.getString("wizards_ViewConfAlgorithm_" + layoutID.replace("LayoutAlgorithm", "") + "_description");
        if (layoutDesc == null || layoutDesc.equals("")) {
            return layoutID;
        }
        return layoutDesc;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)WizardHelper.createData(4, 4, true, false, -1, -1));
        Label viewLabel1 = new Label(composite, 16384);
        viewLabel1.setText(PluginProperties.wizards_ViewConfCurrentView_label);
        viewLabel1.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 1));
        Label viewLabel2 = new Label(composite, 16384);
        viewLabel2.setText(String.valueOf(Views.getInstance().getSelectedView().getOfficialName()) + " (" + Views.getInstance().getSelectedView().getInternalName() + ")");
        viewLabel2.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 2));
        viewLabel2.setFont(FontUtil.getSystemStyle(3));
        Label dummyLabel = new Label(composite, 16384);
        dummyLabel.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        Label dummyLabel2 = new Label(composite, 16384);
        dummyLabel2.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, -1, 3));
        Label selectLabel = new Label(composite, 16448);
        selectLabel.setText(PluginProperties.wizards_ViewConfCreateSelect_label);
        selectLabel.setLayoutData((Object)WizardHelper.createData(-1, 1, false, false, 2, 1));
        this.algorithmCombo = new Combo(composite, 12);
        this.algorithmCombo.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 1));
        final Label descLabel = new Label(composite, 16384);
        descLabel.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 3));
        String[] stringArray = this.layoutIDs;
        int n = this.layoutIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String layoutID = stringArray[n2];
            String layoutName = this.getLayoutName(layoutID);
            this.algorithmCombo.add(layoutName);
            this.algorithmCombo.setData(layoutName, (Object)layoutID);
            ++n2;
        }
        this.algorithmCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                descLabel.setText(CreateViewConfWizardPage.this.getLayoutDescription(CreateViewConfWizardPage.this.algorithmCombo.getData(CreateViewConfWizardPage.this.algorithmCombo.getText()).toString()));
            }
        });
        if (this.algorithmCombo.getItemCount() > 0) {
            this.algorithmCombo.select(3);
            descLabel.setText(this.getLayoutDescription(this.algorithmCombo.getData(this.algorithmCombo.getText()).toString()));
        }
        this.setMessage(PluginProperties.wizards_ViewConfCreate_message);
        this.setControl((Control)composite);
        this.getShell().pack();
        WizardHelper.resizeDialog(this.getShell());
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage("activity");
    }

    public void dispose() {
        if (this.algorithmCombo != null && !this.algorithmCombo.isDisposed()) {
            this.algorithmCombo.dispose();
            this.algorithmCombo = null;
        }
        super.dispose();
    }
}

