/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.view;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.commands.view.CreateLayoutDataCommand;
import org.eclipse.jwt.we.commands.view.ImportLayoutDataCommand;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.misc.wizards.view.pages.ActivityViewConfWizardPage;
import org.eclipse.jwt.we.misc.wizards.view.pages.CreateViewConfWizardPage;
import org.eclipse.jwt.we.misc.wizards.view.pages.ImportViewConfWizardPage;
import org.eclipse.jwt.we.misc.wizards.view.pages.ModeViewConfWizardPage;
import org.eclipse.jwt.we.misc.wizards.view.pages.PreviewViewConfWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConfWizard
extends Wizard
implements INewWizard {
    static final Logger logger = Logger.getLogger(ViewConfWizard.class);
    protected ModeViewConfWizardPage modePage;
    protected ImportViewConfWizardPage importPage;
    protected CreateViewConfWizardPage createPage;
    protected ActivityViewConfWizardPage activityPage;
    protected PreviewViewConfWizardPage previewPage;
    protected IWorkbench workbench;
    private Command previewLayoutCommand;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(PluginProperties.wizards_ViewConf_title);
        this.setDefaultPageImageDescriptor(Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView()).createImageDescriptor(PluginProperties.editor_Wizard_icon));
    }

    public void addPages() {
        this.modePage = new ModeViewConfWizardPage("mode", this.workbench);
        this.modePage.setTitle(PluginProperties.wizards_ViewConfSelect_title);
        this.addPage((IWizardPage)this.modePage);
        this.importPage = new ImportViewConfWizardPage("import", this.workbench);
        this.importPage.setTitle(PluginProperties.wizards_ViewConfImport_title);
        this.addPage((IWizardPage)this.importPage);
        this.createPage = new CreateViewConfWizardPage("create", this.workbench);
        this.createPage.setTitle(PluginProperties.wizards_ViewConfCreate_title);
        this.addPage((IWizardPage)this.createPage);
        this.activityPage = new ActivityViewConfWizardPage("activity", this.workbench);
        this.activityPage.setTitle(PluginProperties.wizards_ViewConfActivity_title);
        this.addPage((IWizardPage)this.activityPage);
        this.previewPage = new PreviewViewConfWizardPage("preview", this.workbench);
        this.previewPage.setTitle(PluginProperties.wizards_ViewConfPreview_title);
        this.addPage((IWizardPage)this.previewPage);
    }

    public boolean canFinish() {
        if (this.modePage.isImportMode()) {
            return this.getPage("import").isPageComplete();
        }
        if (this.modePage.isCreateMode()) {
            return this.getPage("create").isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        this.disposePreview();
        if (this.modePage.isImportMode()) {
            return this.performFinishImport();
        }
        if (this.modePage.isCreateMode()) {
            return this.performFinishCreate();
        }
        return false;
    }

    public boolean performCancel() {
        this.disposePreview();
        return super.performCancel();
    }

    public boolean performFinishImport() {
        Set<Scope> selectedScopes = this.collectContainedScopes();
        LayoutDataManager.importLayoutData(GeneralHelper.getActiveInstance(), selectedScopes, this.importPage.getSelectedViewID(), Views.getInstance().getSelectedView().getInternalName(), this.importPage.isImportOnlyMissingLayoutData());
        return true;
    }

    public boolean performFinishCreate() {
        Set<Scope> selectedScopes = this.collectContainedScopes();
        LayoutDataManager.createLayoutData(GeneralHelper.getActiveInstance(), selectedScopes, this.createPage.getSelectedLayoutClass());
        return true;
    }

    public void disposePreview() {
        if (this.previewLayoutCommand != null) {
            this.previewLayoutCommand.undo();
            this.previewLayoutCommand.dispose();
            this.previewLayoutCommand = null;
        }
    }

    public void updatePreview() {
        this.disposePreview();
        Set<Scope> selectedScopes = this.collectContainedScopes();
        if (((ModeViewConfWizardPage)this.getPage("mode")).isImportMode()) {
            ImportViewConfWizardPage importPage = (ImportViewConfWizardPage)this.getPage("import");
            this.previewLayoutCommand = new ImportLayoutDataCommand(GeneralHelper.getActiveInstance(), selectedScopes, importPage.getSelectedViewID(), Views.getInstance().getSelectedView().getInternalName(), importPage.isImportOnlyMissingLayoutData());
            this.previewLayoutCommand.execute();
        } else if (((ModeViewConfWizardPage)this.getPage("mode")).isCreateMode()) {
            CreateViewConfWizardPage createPage = (CreateViewConfWizardPage)this.getPage("create");
            this.previewLayoutCommand = new CreateLayoutDataCommand(GeneralHelper.getActiveInstance(), selectedScopes, createPage.getSelectedLayoutClass());
            this.previewLayoutCommand.execute();
        }
    }

    private Set<Scope> collectContainedScopes() {
        HashSet<Scope> selectedScopes = new HashSet<Scope>();
        selectedScopes.addAll(this.activityPage.getSelectedActivities());
        for (Scope scope : this.activityPage.getSelectedActivities()) {
            TreeIterator iter = scope.eAllContents();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                if (!(object instanceof Scope)) continue;
                selectedScopes.add((Scope)object);
            }
        }
        return selectedScopes;
    }
}

