/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures.internal;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.figures.internal.CombinedImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ScalingImageDescriptor
extends ImageDescriptor {
    private ImageDescriptor imageDescriptor;
    private Dimension size;

    public ScalingImageDescriptor(ImageDescriptor imageDescriptor, Dimension size) {
        this.setSize(size);
        this.setImageDescriptor(imageDescriptor);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        if (imageDescriptor != null) {
            if (imageDescriptor instanceof ScalingImageDescriptor) {
                this.imageDescriptor = ((ScalingImageDescriptor)imageDescriptor).getImageDescriptor();
            }
            if (imageDescriptor instanceof CombinedImageDescriptor) {
                CombinedImageDescriptor combinedImageDescriptor = (CombinedImageDescriptor)imageDescriptor;
                ImageDescriptor[] imageDescriptorArray = combinedImageDescriptor.getImageDescriptors();
                int n = imageDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ImageDescriptor descriptor = imageDescriptorArray[n2];
                    if (descriptor != null && descriptor instanceof ScalingImageDescriptor) {
                        ((ScalingImageDescriptor)descriptor).setSize(null);
                    }
                    ++n2;
                }
            }
        }
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public ImageData getImageData() {
        if (this.imageDescriptor == null) {
            return null;
        }
        ImageData imageData = this.imageDescriptor.getImageData();
        if (imageData == null) {
            return null;
        }
        if (this.size != null && (imageData.width != this.size.width || imageData.height != this.size.height)) {
            imageData = imageData.scaledTo(this.size.width, this.size.height);
        }
        return imageData;
    }

    public String toString() {
        if (this.size == null) {
            return "" + this.imageDescriptor;
        }
        return this.imageDescriptor + "@" + this.size.width + "x" + this.size.height;
    }

    public Image createImage() {
        return Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[0]).getImage(this);
    }
}

