/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.selection;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jwt.we.misc.logging.Logger;

public abstract class AbstractSelectionProvider
implements ISelectionProvider {
    private static final Logger logger = Logger.getLogger(AbstractSelectionProvider.class);
    private ListenerList selectionChangedListeners = new ListenerList();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected Object[] getSelectionChangedListener() {
        return this.selectionChangedListeners.getListeners();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        Object[] objectArray = this.getSelectionChangedListener();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((ISelectionChangedListener)listener).selectionChanged(event);
            }
            catch (Exception e) {
                logger.warning(e);
            }
            ++n2;
        }
    }
}

