/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.preferences.wrappers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jwt.we.editors.preferences.wrappers.WEPreferenceStoreInterface;
import org.eclipse.swt.graphics.Color;

public class ColorPreferenceWrapper {
    private String preferenceKey;
    private Color cachedColor;
    private String cachedColorString;
    private Color cachedColorDefault;
    private String cachedColorStringDefault;
    private static List<Color> colorRegistry;

    public ColorPreferenceWrapper(String preferenceKey) {
        this.preferenceKey = preferenceKey;
        colorRegistry = new ArrayList<Color>();
    }

    public Color get() {
        String colorString = WEPreferenceStoreInterface.getValueAsString(this.preferenceKey);
        if (this.cachedColor != null && !this.cachedColor.isDisposed() && colorString.equals(this.cachedColorString)) {
            return this.cachedColor;
        }
        String[] colorStringSplit = colorString.split(",");
        this.cachedColor = new Color(null, new Integer(colorStringSplit[0]).intValue(), new Integer(colorStringSplit[1]).intValue(), new Integer(colorStringSplit[2]).intValue());
        this.cachedColorString = colorString;
        colorRegistry.add(this.cachedColor);
        return this.cachedColor;
    }

    public void set(Color value) {
        String colorString = String.valueOf(value.getRed()) + "," + value.getGreen() + "," + value.getBlue();
        WEPreferenceStoreInterface.setValueString(this.preferenceKey, colorString);
    }

    public Color getDefault() {
        String colorString = WEPreferenceStoreInterface.getDefaultValueAsString(this.preferenceKey);
        if (this.cachedColorDefault != null && !this.cachedColorDefault.isDisposed() && colorString.equals(this.cachedColorStringDefault)) {
            return this.cachedColorDefault;
        }
        String[] colorStringSplit = colorString.split(",");
        this.cachedColorDefault = new Color(null, new Integer(colorStringSplit[0]).intValue(), new Integer(colorStringSplit[1]).intValue(), new Integer(colorStringSplit[2]).intValue());
        this.cachedColorStringDefault = colorString;
        colorRegistry.add(this.cachedColorDefault);
        return this.cachedColorDefault;
    }

    public static void disposeColors() {
        for (Color color : colorRegistry) {
            if (color.isDisposed()) continue;
            color.dispose();
        }
        colorRegistry.clear();
    }
}

