/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.edit.aspects.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jwt.we.conf.edit.aspects.provider.command.AspectCommandParameter;
import org.eclipse.jwt.we.conf.edit.aspects.provider.command.CopyCommandWithAspects;
import org.eclipse.jwt.we.conf.edit.aspects.provider.command.CreateChildAspectCommand;
import org.eclipse.jwt.we.conf.edit.aspects.provider.command.CreateChildCommandWithAspects;
import org.eclipse.jwt.we.conf.edit.aspects.provider.command.InitializeCopyCommandWithAspects;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.ConfModel;
import org.eclipse.jwt.we.conf.model.ConfPackage;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.conf.model.aspects.factory.AspectFactory;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectEnrichedItemProviderAdapter
extends ItemProviderAdapter {
    protected boolean adapterFactoryInited = false;

    public AspectEnrichedItemProviderAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getBackground(Object object) {
        return super.getBackground(object);
    }

    public Collection<?> getChildren(Object object) {
        Collection children = super.getChildren(object);
        if (object instanceof EObject) {
            EObject modelElement = (EObject)object;
            if (!this.adapterFactoryInited) {
                this.initAdapterFactory(modelElement);
            }
            List aspectInstances = AspectManager.INSTANCE.getAspectInstances(modelElement);
            children.addAll(aspectInstances);
        }
        return children;
    }

    protected synchronized void initAdapterFactory(EObject modelElement) {
        IChangeNotifier notifyingAdapterFactory = null;
        if (this.adapterFactory instanceof IChangeNotifier) {
            notifyingAdapterFactory = (IChangeNotifier)this.adapterFactory;
        }
    }

    public void fireNotifyChanged(Notification notification) {
        super.fireNotifyChanged(notification);
        ConfPlugin.getDefaultAspectEventManager().notifyChanged(notification);
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        Collection collectedNewChildDescriptors = super.getNewChildDescriptors(object, editingDomain, sibling);
        this.collectNewChildAspectDescriptors(collectedNewChildDescriptors, object);
        return collectedNewChildDescriptors;
    }

    protected void collectNewChildAspectDescriptors(Collection newChildDescriptors, Object object) {
        if (object instanceof EObject) {
            EObject modelElement = (EObject)object;
            List aspects = AspectManager.INSTANCE.getAspects(modelElement);
            for (Aspect aspect : aspects) {
                AspectInstance aspectInstance;
                if (!aspect.isMultiple()) {
                    boolean alreadyInstanciated = false;
                    for (AspectInstance aspectInstance2 : AspectManager.INSTANCE.getAspectInstances(modelElement)) {
                        if (!aspect.getId().equals(aspectInstance2.getId())) continue;
                        alreadyInstanciated = true;
                        break;
                    }
                    if (alreadyInstanciated) continue;
                }
                if ((aspectInstance = AspectFactory.INSTANCE.createAspectInstance(aspect, (EObject)object)) == null) continue;
                newChildDescriptors.add(this.createChildAspectParameter(ConfPackage.Literals.CONF_MODEL__ASPECT_INSTANCES, aspectInstance, aspect.getId()));
            }
        }
    }

    protected CommandParameter createChildAspectParameter(Object feature, Object child, String aspectId) {
        return new AspectCommandParameter(null, feature, child, aspectId);
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        commandParameter = this.unwrapCommandValues(commandParameter, commandClass);
        if (commandClass == CreateChildCommand.class) {
            CommandParameter newChildParameter;
            EStructuralFeature commandFeature = commandParameter.getEStructuralFeature();
            if (commandFeature != null || !(commandParameter.getValue() instanceof CommandParameter) || !(((CommandParameter)commandParameter.getValue()).getFeature() instanceof EStructuralFeature)) {
                return super.createCommand(object, domain, commandClass, commandParameter);
            }
            commandFeature = (EStructuralFeature)((CommandParameter)commandParameter.getValue()).getFeature();
            if (commandFeature.getFeatureID() == 2 && (newChildParameter = (CommandParameter)commandParameter.getValue()) instanceof AspectCommandParameter) {
                AspectCommandParameter newChildAspectParameter = (AspectCommandParameter)((Object)commandParameter.getValue());
                return this.createCreateChildAspectCommand(domain, (EObject)AspectManager.INSTANCE.getConfModel(commandParameter.getEOwner()), newChildParameter.getEStructuralFeature(), newChildParameter.getValue(), newChildParameter.getIndex(), commandParameter.getCollection(), newChildAspectParameter.getAspectId());
            }
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        ArrayList listWithoutAspectInstances = new ArrayList();
        ArrayList<AspectInstance> aspectInstances = null;
        for (Object child : commandParameter.getCollection()) {
            if (child instanceof AspectInstance) {
                AspectInstance aspectInstance = (AspectInstance)child;
                if (aspectInstances == null) {
                    aspectInstances = new ArrayList<AspectInstance>();
                }
                aspectInstances.add(aspectInstance);
                continue;
            }
            listWithoutAspectInstances.add(child);
        }
        Command commandWhitoutAspects = super.factorAddCommand(domain, new CommandParameter(commandParameter.getOwner(), null, listWithoutAspectInstances, commandParameter.getIndex()));
        if (commandWhitoutAspects == UnexecutableCommand.INSTANCE || aspectInstances == null) {
            return commandWhitoutAspects;
        }
        CompoundCommand compoundAddCommand = null;
        if (!(commandWhitoutAspects instanceof CompoundCommand)) {
            compoundAddCommand = new CompoundCommand(Integer.MAX_VALUE);
            compoundAddCommand.append(commandWhitoutAspects);
        }
        ConfModel confModel = AspectManager.INSTANCE.getConfModel(commandParameter.getEOwner());
        compoundAddCommand.append(this.createAddCommand(domain, (EObject)confModel, (EStructuralFeature)ConfPackage.eINSTANCE.getConfModel_AspectInstances(), aspectInstances, 0));
        return compoundAddCommand;
    }

    protected Command createCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new CopyCommandWithAspects(domain, owner, helper);
    }

    protected Command createInitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        return new InitializeCopyCommandWithAspects(domain, owner, helper);
    }

    protected Command createCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection) {
        return new CreateChildCommandWithAspects(domain, owner, feature, value, index, collection, (CreateChildCommand.Helper)this);
    }

    protected Command createCreateChildAspectCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index, Collection<?> collection, String aspectId) {
        return new CreateChildAspectCommand(domain, owner, feature, value, index, collection, this, aspectId);
    }
}

