/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverserContext;

public abstract class AbstractTreeTraverser<T> {
    public static final int NO_DEPTH_LIMIT = -1;
    private List<ITreeNodeOperation<T>> m_operations = new ArrayList<ITreeNodeOperation<T>>();
    private T m_rootNode;
    private int m_maxDepth = -1;

    public AbstractTreeTraverser(T rootNode) {
        this.m_rootNode = rootNode;
    }

    public AbstractTreeTraverser(T rootNode, ITreeNodeOperation<T> operation) {
        this(rootNode);
        this.m_operations.add(operation);
    }

    public AbstractTreeTraverser(T rootNode, ITreeNodeOperation<T> operation, int maxTraversalDepth) {
        this(rootNode, operation);
        this.m_maxDepth = maxTraversalDepth;
    }

    protected void traverseImpl(ITreeTraverserContext<T> context, T parent, T node) {
        if (this.m_maxDepth == -1 || this.m_maxDepth > context.getCurrentTreePath().size()) {
            context.append(node);
            HashSet<ITreeNodeOperation<T>> suspendedOps = null;
            for (ITreeNodeOperation<T> operation : this.m_operations) {
                boolean continueWork = operation.operate(context, parent, node, false);
                if (continueWork) continue;
                if (suspendedOps == null) {
                    suspendedOps = new HashSet<ITreeNodeOperation<T>>(this.m_operations.size());
                }
                suspendedOps.add(operation);
            }
            if (suspendedOps != null) {
                this.m_operations.removeAll(suspendedOps);
            }
            if (context.isContinue() && !this.m_operations.isEmpty()) {
                Iterator<T> iter = this.getChildIterator(node);
                while (iter.hasNext()) {
                    this.traverseImpl(context, node, iter.next());
                }
            }
            if (suspendedOps != null) {
                this.m_operations.addAll(suspendedOps);
            }
            if (context.isContinue()) {
                for (ITreeNodeOperation<T> operation : this.m_operations) {
                    operation.postOperate(context, parent, node, false);
                }
            }
            context.removeLast();
        }
    }

    protected abstract Iterator<T> getChildIterator(T var1);

    public void traverse() {
        this.traverseImpl(new TreeTraverserContext<T>(this.m_rootNode), null, this.m_rootNode);
    }

    protected List<ITreeNodeOperation<T>> getOperations() {
        return this.m_operations;
    }

    public void addOperation(ITreeNodeOperation<T> op) {
        this.m_operations.add(op);
    }
}

