/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.preferences.database;

import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;

public class H2ConnectionInfo
extends DatabaseConnectionInfo {
    public static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    public static final String JDBC_PRE = "jdbc:h2:";
    public static final String PROP_NAME_LOCATION = "location";
    private static final String DEFAULT_USERNAME = "sa";
    private static final String DEFAULT_PASSWORD = "";
    private String m_location = "~/.jubula/database/embedded";

    public H2ConnectionInfo() {
        this.setProperty("javax.persistence.jdbc.user", DEFAULT_USERNAME);
        this.setProperty("javax.persistence.jdbc.password", DEFAULT_PASSWORD);
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
        this.fireConnectionUrlChanged();
    }

    @Override
    public String getConnectionUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(JDBC_PRE).append(this.getLocation()).append(";MVCC=TRUE;AUTO_SERVER=TRUE;DB_CLOSE_ON_EXIT=FALSE");
        return sb.toString();
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }
}

