/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.PoMaker;

public class TestDataCubePM {
    private TestDataCubePM() {
    }

    public static List<ITestDataCubePO> computeReuser(IParameterInterfacePO tdc, EntityManager session) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestDataCubeClass());
        query.select((Selection)from).where((Expression)builder.and((Expression)builder.isNotNull((Expression)from.get("hbmReferencedDataCube")), (Expression)builder.equal((Expression)from.get("hbmParentProjectId"), (Object)tdc.getParentProjectId())));
        List queryResult = session.createQuery(query).getResultList();
        ArrayList<ITestDataCubePO> result = new ArrayList<ITestDataCubePO>();
        for (ITestDataCubePO pio : queryResult) {
            if (!TestDataCubePM.areEqual(pio.getReferencedDataCube(), tdc)) continue;
            result.add(pio);
        }
        return result;
    }

    public static List<IParamNodePO> computeParamNodeReuser(IParameterInterfacePO pioToSearch, EntityManager session, IProjectPO proj) {
        Query query = session.createQuery("select paramPO from ParamNodePO paramPO where paramPO.hbmParentProjectId = :projId");
        query.setParameter("projId", (Object)proj.getId());
        List queryResult = query.getResultList();
        ArrayList<IParamNodePO> result = new ArrayList<IParamNodePO>();
        block0: for (IParameterInterfacePO pio : queryResult) {
            if (!(pio instanceof IParamNodePO)) continue;
            IParamNodePO pn = (IParamNodePO)pio;
            if (TestDataCubePM.areEqual(pn.getReferencedDataCube(), pioToSearch)) {
                result.add(pn);
                continue;
            }
            for (IDataSetPO dataSet : pn.getDataManager().getDataSets()) {
                int i = 0;
                while (i < dataSet.getColumnCount()) {
                    if (TestDataBP.isCTDSReferenced(pioToSearch.getName(), dataSet.getValueAt(i))) {
                        result.add(pn);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private static boolean areEqual(IParameterInterfacePO po1, IParameterInterfacePO po2) {
        if (po1 != null && po2 != null) {
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)po1.getId(), (Object)po2.getId());
            return eb.isEquals();
        }
        return false;
    }
}

