/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public abstract class RangeModeCommand
extends DesignerCommand {
    DOMRange _resultRange = null;

    public RangeModeCommand(String label, IHTMLGraphicalViewer viewer) {
        super(label, viewer);
    }

    protected boolean prePreExecute() {
        int position = -1;
        int length = -1;
        ISelection selection = this.getViewer().getSelection();
        if (selection != null) {
            if (this.getViewer().isInRangeMode()) {
                DesignRange range = (DesignRange)selection;
                if (range.isValid()) {
                    IDOMPosition domPos = DOMPositionHelper.toDOMPosition(range.getStartPosition());
                    IDOMPosition domEnd = DOMPositionHelper.toDOMPosition(range.getEndPosition());
                    if (!EditValidateUtil.validPosition(domPos) || !EditValidateUtil.validPosition(domEnd)) {
                        return false;
                    }
                    position = EditModelQuery.getIndexedRegionLocation(domPos);
                    int end = EditModelQuery.getIndexedRegionLocation(domEnd);
                    if (end < position) {
                        length = position - end;
                        position = end;
                    } else {
                        length = end - position;
                    }
                }
            } else {
                Object object = ((IStructuredSelection)selection).getFirstElement();
                if (object instanceof ElementEditPart) {
                    IDOMNode node = ((ElementEditPart)((Object)object)).getIDOMNode();
                    position = EditModelQuery.getNodeStartIndex((Node)node);
                    length = EditModelQuery.getNodeLenth((Node)node);
                } else {
                    return false;
                }
            }
            if (position >= 0 && length >= 0) {
                this.getModel().beginRecording((Object)this, this.getLabel(), position, length);
            } else {
                this.getModel().beginRecording((Object)this, this.getLabel());
            }
            this.getViewer().startSelectionChange();
            this.getModel().aboutToChangeModel();
            return true;
        }
        return false;
    }

    protected final void doExecute() {
        DesignRange range = this.getViewer().getRangeSelection();
        if (range != null && range.isValid()) {
            DOMRange domrange = range == null || !range.isValid() ? null : this.toDOMRange(range);
            this._resultRange = this.doRangeExecute(domrange);
        }
    }

    protected final ISelection getAfterCommandDesignerSelection() {
        if (this._resultRange == null) {
            return null;
        }
        IDOMPosition startPos = this._resultRange.getStartPosition();
        DesignPosition start = DOMPositionHelper.toDesignPosition(startPos);
        if (this._resultRange.isEmpty()) {
            return new DesignRange(start, start);
        }
        IDOMPosition endPos = this._resultRange.getEndPosition();
        return new DesignRange(start, DOMPositionHelper.toDesignPosition(endPos));
    }

    private DOMRange toDOMRange(DesignRange range) {
        return new DOMRange(DOMPositionHelper.toDOMPosition(range.getStartPosition()), DOMPositionHelper.toDOMPosition(range.getEndPosition()));
    }

    protected abstract DOMRange doRangeExecute(DOMRange var1);

    protected static void appendChild(Node parent, Node ref, Node child) {
        Node next = ref.getNextSibling();
        if (next == null) {
            parent.appendChild(child);
        } else {
            parent.insertBefore(child, next);
        }
    }
}

