/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.annotate.util.DefaultTableUtil;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.DatabaseGroup;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JavaClassMapping;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JpaMakePersistentWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JpaMakePersistentWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ClassMappingPage
extends WizardPage {
    final JpaProject jpaProject;
    final ResourceManager resourceManager;
    private JavaClassMapping[] javaClassMappings;
    private JpaMakePersistentWizardPage makePersistentPage;
    private DatabaseGroup databaseGroup;
    private Schema schema;
    private List<String> tableNames;
    private TableViewer classMappingTableViewer;
    private final Set<Listener> listeners = Collections.synchronizedSet(new HashSet());
    private static final int TYPE_COLUMN_WIDTH = 200;
    private static final int DATABASE_TABLE_COLUMN_WIDTH = 200;
    private static final int PRIMARY_KEY_PROPERTY_COLUMN_WIDTH = 200;
    private static final int MAPPING_TABLE_HEIGHT = 180;

    public ClassMappingPage(JpaProject proj, JavaClassMapping[] javaClassMappings, ResourceManager resourceManager, JpaMakePersistentWizardPage makePersistentPage) {
        super("Class Mapping Properties");
        this.resourceManager = resourceManager;
        this.jpaProject = proj;
        this.javaClassMappings = javaClassMappings;
        this.makePersistentPage = makePersistentPage;
        this.tableNames = new ArrayList<String>();
        this.setTitle(JptJpaUiMakePersistentMessages.CLASS_MAPPING_PAGE_TITLE);
        this.setMessage(JptJpaUiMakePersistentMessages.CLASS_MAPPING_PAGE_DESC);
        this.makePersistentPage.addListener(new JpaMakePersistentWizardPage.Listener(){

            @Override
            public void mappingTypeChanged(JavaClassMapping javaClassMapping) {
                ClassMappingPage.this.handleMappingTypeChange(javaClassMapping);
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.databaseGroup = this.createDatabaseGroup(composite, -1);
        Composite comp = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        comp.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        comp.setLayout((Layout)gridLayout);
        this.classMappingTableViewer = new TableViewer(comp, 68352);
        this.classMappingTableViewer.getTable().setLinesVisible(true);
        this.classMappingTableViewer.getTable().setHeaderVisible(true);
        this.classMappingTableViewer.setContentProvider((IContentProvider)new ClassMappingContentProvider());
        this.classMappingTableViewer.setComparator((ViewerComparator)new JpaMakePersistentWizard.TypeComparator());
        this.createTypeTableColumn();
        this.createDBTableColumn();
        this.createPrimaryKeyPropertyColumn();
        this.classMappingTableViewer.setInput((Object)this.javaClassMappings);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 600;
        data.heightHint = 180;
        this.classMappingTableViewer.getTable().setLayoutData((Object)data);
        this.setControl((Control)composite);
    }

    public void dispose() {
        if (this.databaseGroup != null) {
            this.databaseGroup.dispose();
        }
        super.dispose();
    }

    public JavaClassMapping[] getJavaClassMappings() {
        return this.javaClassMappings;
    }

    public Schema getSchema() {
        return this.schema;
    }

    private void setSchema(Schema s) {
        this.schema = s;
    }

    private DatabaseGroup createDatabaseGroup(Composite parent, int widthHint) {
        DatabaseGroup dbGroup = new DatabaseGroup(this.getContainer(), this.jpaProject, parent, this.resourceManager, widthHint);
        class DatabasePageListener
        implements DatabaseGroup.Listener {
            DatabasePageListener() {
            }

            @Override
            public void selectedConnectionProfileChanged(ConnectionProfile connectionProfile) {
                ClassMappingPage.this.jpaProject.getDataSource().setConnectionProfileName(connectionProfile.getName());
            }

            @Override
            public void selectedSchemaChanged(Schema schema) {
                ClassMappingPage.this.setSchema(schema);
                ClassMappingPage.this.updateTableNames();
            }
        }
        dbGroup.addListener(new DatabasePageListener());
        dbGroup.init();
        return dbGroup;
    }

    protected void createTypeTableColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classMappingTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptJpaUiMakePersistentMessages.CLASS_MAPPING_PAGE_TYPE_TABLE_COLUMN);
        column.setLabelProvider((CellLabelProvider)new TypeColumnLabelProvider());
    }

    protected void createDBTableColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classMappingTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptJpaUiMakePersistentMessages.CLASS_MAPPING_PAGE_MAPPING_TABLE_COLUMN);
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.classMappingTableViewer){

            protected Object getValue(Object element) {
                return ((JavaClassMapping)element).getDBTable();
            }

            protected void setValue(Object element, Object value) {
                ((JavaClassMapping)element).setDBTable((String)value);
                ClassMappingPage.this.syncPKProp((JavaClassMapping)element);
                this.getViewer().update(element, null);
                ClassMappingPage.this.fireClassMappingChanged((JavaClassMapping)element);
            }

            protected CellEditor getCellEditor(Object element) {
                ComboBoxViewerCellEditor comboCellEditor = new ComboBoxViewerCellEditor((Composite)ClassMappingPage.this.classMappingTableViewer.getControl());
                comboCellEditor.setLabelProvider((IBaseLabelProvider)ClassMappingPage.this.buildDBTableComboCellEditorLabelProvider());
                comboCellEditor.setContentProvider(ClassMappingPage.this.buildDBTableComboCellEditorContentProvider());
                comboCellEditor.setInput((Object)ClassMappingPage.this.tableNames);
                return comboCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column.setLabelProvider((CellLabelProvider)new DBTableColumnLabelProvider());
    }

    protected void createPrimaryKeyPropertyColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classMappingTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptJpaUiMakePersistentMessages.CLASS_MAPPING_PAGE_PRIMARY_KEY_PROPERTY_COLUMN);
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.classMappingTableViewer){

            protected Object getValue(Object element) {
                return ((JavaClassMapping)element).getPrimaryKeyProperty();
            }

            protected void setValue(Object element, Object value) {
                ((JavaClassMapping)element).setPrimaryKeyProperty((String)value);
                this.getViewer().update(element, null);
                ClassMappingPage.this.fireClassMappingChanged((JavaClassMapping)element);
            }

            protected CellEditor getCellEditor(Object element) {
                ComboBoxViewerCellEditor comboCellEditor = new ComboBoxViewerCellEditor((Composite)ClassMappingPage.this.classMappingTableViewer.getControl());
                comboCellEditor.setLabelProvider((IBaseLabelProvider)ClassMappingPage.this.buildDBTableComboCellEditorLabelProvider());
                comboCellEditor.setContentProvider(ClassMappingPage.this.buildPrimaryKeyComboCellEditorContentProvider());
                JavaClassMapping mapping = (JavaClassMapping)element;
                comboCellEditor.setInput((Object)ClassMappingPage.this.getPKPropertyNames(mapping.getJDTType()));
                return comboCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column.setLabelProvider((CellLabelProvider)new PrimaryKeyPropertyColumnLabelProvider());
    }

    public void addListener(Listener listener) {
        if (!this.listeners.add(listener)) {
            throw new IllegalArgumentException("duplicate listener: " + listener);
        }
    }

    public void removeListener(Listener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("missing listener: " + listener);
        }
    }

    private Iterator<Listener> listeners() {
        return IteratorTools.clone(this.listeners);
    }

    private void fireClassMappingChanged(JavaClassMapping javaClassMapping) {
        Iterator<Listener> stream = this.listeners();
        while (stream.hasNext()) {
            stream.next().classMappingChanged(javaClassMapping);
        }
    }

    private void syncPKProp(JavaClassMapping javaClassMapping) {
        String pkProp;
        if (javaClassMapping.getDBTable() != null && (pkProp = this.computeDefaultPKProp(javaClassMapping.getDBTable(), javaClassMapping.getJDTType())) != null) {
            javaClassMapping.setPrimaryKeyProperty(pkProp);
        }
    }

    private String computeDefaultPKProp(String tableName, IType jdtType) {
        Table table = this.getSchema().getTableNamed(tableName);
        if (table == null) {
            return null;
        }
        if (table.getPrimaryKeyColumnsSize() != 1) {
            return null;
        }
        Column pkCol = table.getPrimaryKeyColumn();
        String pkPropName = AnnotateMappingUtil.dbNameToJavaName((String)pkCol.getName());
        List<String> pkPropNames = this.getPKPropertyNames(jdtType);
        for (String temp : pkPropNames) {
            if (!temp.equalsIgnoreCase(pkPropName)) continue;
            return temp;
        }
        return null;
    }

    private String computeDefaultTableName(String fqClassName) {
        Table table;
        if (this.schema != null && (table = DefaultTableUtil.findTable((Schema)this.schema, (String)fqClassName)) != null) {
            return table.getName();
        }
        return null;
    }

    private List<String> getPKPropertyNames(IType jdtType) {
        ArrayList<String> props = new ArrayList<String>();
        try {
            IField[] fields;
            IField[] iFieldArray = fields = jdtType.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (!Flags.isSuper((int)field.getFlags()) && !Flags.isStatic((int)field.getFlags())) {
                    String typeStr = field.getTypeSignature();
                    if (!ClassNameTools.isPrimitive((String)(typeStr = Signature.toString((String)typeStr)))) {
                        typeStr = AnnotateMappingUtil.resolveType((String)typeStr, (IType)jdtType);
                    }
                    if (AnnotateMappingUtil.isString((String)typeStr) || AnnotateMappingUtil.isNumeric((String)typeStr) || AnnotateMappingUtil.isDate((String)typeStr, (IProject)this.jpaProject.getProject())) {
                        props.add(field.getElementName());
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException je) {
            JptJpaUiPlugin.instance().logError(je);
        }
        return props;
    }

    private void updateTableNames() {
        this.tableNames.clear();
        if (this.schema != null) {
            for (Table table : this.schema.getTables()) {
                this.tableNames.add(table.getName());
            }
            JavaClassMapping[] javaClassMappingArray = this.javaClassMappings;
            int n = this.javaClassMappings.length;
            int n2 = 0;
            while (n2 < n) {
                String tableName;
                JavaClassMapping javaClassMapping = javaClassMappingArray[n2];
                if (javaClassMapping.getMappingKey().equals("entity") && (tableName = this.computeDefaultTableName(javaClassMapping.getName())) != null) {
                    javaClassMapping.setDBTable(tableName);
                    this.syncPKProp(javaClassMapping);
                    this.fireClassMappingChanged(javaClassMapping);
                }
                ++n2;
            }
        }
        if (this.classMappingTableViewer != null) {
            this.classMappingTableViewer.refresh(true);
        }
    }

    private void handleMappingTypeChange(JavaClassMapping javaClassMapping) {
        this.classMappingTableViewer.getTable().clearAll();
        this.classMappingTableViewer.refresh(true);
        this.fireClassMappingChanged(javaClassMapping);
    }

    protected ColumnLabelProvider buildDBTableComboCellEditorLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        };
    }

    protected IStructuredContentProvider buildDBTableComboCellEditorContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    protected IStructuredContentProvider buildPrimaryKeyComboCellEditorContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    private final class ClassMappingContentProvider
    implements IStructuredContentProvider {
        private ClassMappingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            JavaClassMapping[] javaClassMappings;
            ArrayList<JavaClassMapping> entityMappings = new ArrayList<JavaClassMapping>();
            JavaClassMapping[] javaClassMappingArray = javaClassMappings = (JavaClassMapping[])inputElement;
            int n = javaClassMappings.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClassMapping javaClassMapping = javaClassMappingArray[n2];
                if (javaClassMapping.getMappingKey().equals("entity")) {
                    entityMappings.add(javaClassMapping);
                }
                ++n2;
            }
            return entityMappings.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DBTableColumnLabelProvider
    extends ColumnLabelProvider {
        private DBTableColumnLabelProvider() {
        }

        public String getText(Object element) {
            JavaClassMapping mapping = (JavaClassMapping)element;
            return mapping.getDBTable();
        }

        public Image getImage(Object element) {
            JavaClassMapping mapping = (JavaClassMapping)element;
            return mapping.getDBTable() == null ? null : this.getResourceManager().createImage(JptJpaUiImages.TABLE);
        }

        private ResourceManager getResourceManager() {
            return ClassMappingPage.this.resourceManager;
        }
    }

    public static interface Listener
    extends EventListener {
        public void classMappingChanged(JavaClassMapping var1);
    }

    private class PrimaryKeyPropertyColumnLabelProvider
    extends ColumnLabelProvider {
        private PrimaryKeyPropertyColumnLabelProvider() {
        }

        public String getText(Object element) {
            JavaClassMapping mapping = (JavaClassMapping)element;
            return mapping.getPrimaryKeyProperty();
        }

        public Image getImage(Object element) {
            JavaClassMapping mapping = (JavaClassMapping)element;
            return mapping.getPrimaryKeyProperty() == null ? null : this.getResourceManager().createImage(JptJpaUiImages.KEY);
        }

        private ResourceManager getResourceManager() {
            return ClassMappingPage.this.resourceManager;
        }
    }

    private final class TypeColumnLabelProvider
    extends ColumnLabelProvider {
        private final JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(2320);

        private TypeColumnLabelProvider() {
        }

        public String getText(Object element) {
            return this.javaElementLabelProvider.getText((Object)((JavaClassMapping)element).getJDTType());
        }

        public Image getImage(Object element) {
            return this.javaElementLabelProvider.getImage((Object)((JavaClassMapping)element).getJDTType());
        }
    }
}

