/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaElementReference;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractAccessor;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.PersistentFieldValidator;

public class FieldAccessor
extends AbstractAccessor {
    private final JavaResourceField resourceField;

    public FieldAccessor(PersistentAttribute parent, JavaResourceField resourceField) {
        super(parent);
        this.resourceField = resourceField;
    }

    public JavaResourceField getResourceAttribute() {
        return this.resourceField;
    }

    @Override
    public boolean isFor(JavaResourceField field) {
        return this.resourceField == field;
    }

    @Override
    public boolean isFor(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        return false;
    }

    @Override
    public AccessType getDefaultAccess() {
        return AccessType.FIELD;
    }

    public boolean isPublic() {
        return this.resourceField.isPublic();
    }

    public boolean isFinal() {
        return this.resourceField.isFinal();
    }

    @Override
    public JpaValidator buildAttributeValidator(SpecifiedPersistentAttribute persistentAttribute) {
        return new PersistentFieldValidator(persistentAttribute, this);
    }

    @Override
    public JavaSpecifiedPersistentAttribute buildUnannotatedJavaAttribute(PersistentType type) {
        return this.buildJavaAttribute(type, this.buildUnannotatedJavaResourceField());
    }

    protected JavaResourceField buildUnannotatedJavaResourceField() {
        return new UnannotatedJavaResourceField(this.resourceField);
    }

    protected JavaSpecifiedPersistentAttribute buildJavaAttribute(PersistentType type, JavaResourceField javaResourceField) {
        return this.getJpaFactory().buildJavaPersistentField(type, javaResourceField);
    }

    @Override
    public IJavaElement getJavaElement() {
        PersistentType persistentType = this.getAttribute().getDeclaringPersistentType();
        if (persistentType instanceof JavaElementReference) {
            IType jdtType = (IType)((JavaElementReference)((Object)persistentType)).getJavaElement();
            return jdtType == null ? null : jdtType.getField(this.getAttribute().getName());
        }
        return null;
    }

    protected class UnannotatedJavaResourceField
    extends AbstractAccessor.UnannotatedJavaResourceAttribute<JavaResourceField>
    implements JavaResourceField {
        protected UnannotatedJavaResourceField(JavaResourceField field) {
            super((AbstractAccessor)FieldAccessor.this, (JavaResourceAttribute)field);
        }

        public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
            return JavaResourceAnnotatedElement.AstNodeType.FIELD;
        }

        public void synchronizeWith(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclaration) {
        }

        public void resolveTypes(FieldDeclaration fieldDeclaration, VariableDeclarationFragment variableDeclaration) {
        }
    }
}

