/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.Option;

abstract class AbstractFetchCommand
extends TextBuiltin {
    @Option(name="--verbose", aliases={"-v"}, usage="usage_beMoreVerbose")
    private boolean verbose;

    AbstractFetchCommand() {
    }

    protected void showFetchResult(FetchResult r) throws IOException {
        Throwable throwable = null;
        Iterator iterator = null;
        try (ObjectReader reader = this.db.newObjectReader();){
            boolean shownURI = false;
            for (TrackingRefUpdate u : r.getTrackingRefUpdates()) {
                if (!this.verbose && u.getResult() == RefUpdate.Result.NO_CHANGE) continue;
                char type = AbstractFetchCommand.shortTypeOf(u.getResult());
                String longType = AbstractFetchCommand.longTypeOf(reader, u);
                String src = this.abbreviateRef(u.getRemoteName(), false);
                String dst = this.abbreviateRef(u.getLocalName(), true);
                if (!shownURI) {
                    this.outw.println(MessageFormat.format(CLIText.get().fromURI, r.getURI()));
                    shownURI = true;
                }
                this.outw.format(" %c %-17s %-10s -> %s", new Object[]{Character.valueOf(type), longType, src, dst});
                this.outw.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        AbstractFetchCommand.showRemoteMessages(this.errw, r.getMessages());
        for (FetchResult submoduleResult : r.submoduleResults().values()) {
            this.showFetchResult(submoduleResult);
        }
    }

    static void showRemoteMessages(ThrowingPrintWriter writer, String pkt) throws IOException {
        while (pkt.length() > 0) {
            int s;
            int lf = pkt.indexOf(10);
            int cr = pkt.indexOf(13);
            if (lf >= 0 && cr >= 0) {
                s = Math.min(lf, cr);
            } else if (lf >= 0) {
                s = lf;
            } else if (cr >= 0) {
                s = cr;
            } else {
                writer.print((Object)MessageFormat.format(CLIText.get().remoteMessage, pkt));
                writer.println();
                break;
            }
            if (pkt.charAt(s) == '\r') {
                writer.print((Object)MessageFormat.format(CLIText.get().remoteMessage, pkt.substring(0, s)));
                writer.print('\r');
            } else {
                writer.print((Object)MessageFormat.format(CLIText.get().remoteMessage, pkt.substring(0, s)));
                writer.println();
            }
            pkt = pkt.substring(s + 1);
        }
        writer.flush();
    }

    private static String longTypeOf(ObjectReader reader, TrackingRefUpdate u) {
        RefUpdate.Result r = u.getResult();
        if (r == RefUpdate.Result.LOCK_FAILURE) {
            return "[lock fail]";
        }
        if (r == RefUpdate.Result.IO_FAILURE) {
            return "[i/o error]";
        }
        if (r == RefUpdate.Result.REJECTED) {
            return "[rejected]";
        }
        if (ObjectId.zeroId().equals((AnyObjectId)u.getNewObjectId())) {
            return "[deleted]";
        }
        if (r == RefUpdate.Result.NEW) {
            if (u.getRemoteName().startsWith("refs/heads/")) {
                return "[new branch]";
            }
            if (u.getLocalName().startsWith("refs/tags/")) {
                return "[new tag]";
            }
            return "[new]";
        }
        if (r == RefUpdate.Result.FORCED) {
            String aOld = AbstractFetchCommand.safeAbbreviate(reader, u.getOldObjectId());
            String aNew = AbstractFetchCommand.safeAbbreviate(reader, u.getNewObjectId());
            return String.valueOf(aOld) + "..." + aNew;
        }
        if (r == RefUpdate.Result.FAST_FORWARD) {
            String aOld = AbstractFetchCommand.safeAbbreviate(reader, u.getOldObjectId());
            String aNew = AbstractFetchCommand.safeAbbreviate(reader, u.getNewObjectId());
            return String.valueOf(aOld) + ".." + aNew;
        }
        if (r == RefUpdate.Result.NO_CHANGE) {
            return "[up to date]";
        }
        return "[" + r.name() + "]";
    }

    private static String safeAbbreviate(ObjectReader reader, ObjectId id) {
        try {
            return reader.abbreviate((AnyObjectId)id).name();
        }
        catch (IOException cannotAbbreviate) {
            return id.name();
        }
    }

    private static char shortTypeOf(RefUpdate.Result r) {
        if (r == RefUpdate.Result.LOCK_FAILURE) {
            return '!';
        }
        if (r == RefUpdate.Result.IO_FAILURE) {
            return '!';
        }
        if (r == RefUpdate.Result.NEW) {
            return '*';
        }
        if (r == RefUpdate.Result.FORCED) {
            return '+';
        }
        if (r == RefUpdate.Result.FAST_FORWARD) {
            return ' ';
        }
        if (r == RefUpdate.Result.REJECTED) {
            return '!';
        }
        if (r == RefUpdate.Result.NO_CHANGE) {
            return '=';
        }
        return ' ';
    }
}

