/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.escstring.EscString;
import org.eclipse.gef.dot.internal.language.escstring.JustifiedText;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.point.Point;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedShape;
import org.eclipse.gef.dot.internal.language.shape.Shape;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.splinetype.Spline;
import org.eclipse.gef.dot.internal.language.splinetype.SplineType;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.DotArrowShapeDecorations;
import org.eclipse.gef.dot.internal.ui.DotBSplineInterpolator;
import org.eclipse.gef.dot.internal.ui.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.DotHTMLLabelJavaFxNode;
import org.eclipse.gef.dot.internal.ui.DotPolygonBasedNodeShapes;
import org.eclipse.gef.dot.internal.ui.DotRecordBasedJavaFxNode;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.nodes.PolylineInterpolator;
import org.eclipse.gef.fx.nodes.StraightRouter;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Ellipse;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef.zest.fx.ZestProperties;

public class Dot2ZestAttributesConverter
implements IAttributeCopier {
    private DotColorUtil colorUtil = new DotColorUtil();
    private Options options;

    public void copy(IAttributeStore source, IAttributeStore target) {
        if (source instanceof org.eclipse.gef.graph.Node && target instanceof org.eclipse.gef.graph.Node) {
            this.convertAttributes((org.eclipse.gef.graph.Node)source, (org.eclipse.gef.graph.Node)target);
        } else if (source instanceof Edge && target instanceof Edge) {
            this.convertAttributes((Edge)source, (Edge)target);
        } else if (source instanceof Graph && target instanceof Graph) {
            this.convertAttributes((Graph)source, (Graph)target);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void convertAttributes(Edge dot, Edge zest) {
        Double arrowSizeParsed;
        String zestSourceDecorationCssStyle;
        String dotColorScheme;
        String javaFxColor;
        DirType dotDir;
        String dotTailLabel;
        String dotHeadLabel;
        String dotXLabel;
        String dotLabel;
        String dotId = DotAttributes.getId((Edge)dot);
        if (dotId != null) {
            ZestProperties.setCssId((Edge)zest, (String)dotId);
        }
        if ("\\E".equals(dotLabel = DotAttributes.getLabel((Edge)dot))) {
            dotLabel = DotAttributes._getName((Edge)dot);
        }
        if (dotLabel != null) {
            dotLabel = this.decode(dotLabel);
            ZestProperties.setLabel((Edge)zest, (String)dotLabel);
        }
        if ((dotXLabel = DotAttributes.getXlabel((Edge)dot)) != null) {
            dotXLabel = this.decode(dotXLabel);
            ZestProperties.setExternalLabel((Edge)zest, (String)dotXLabel);
        }
        if ((dotHeadLabel = DotAttributes.getHeadlabel((Edge)dot)) != null) {
            dotHeadLabel = this.decode(dotHeadLabel);
            ZestProperties.setTargetLabel((Edge)zest, (String)dotHeadLabel);
        }
        if ((dotTailLabel = DotAttributes.getTaillabel((Edge)dot)) != null) {
            dotTailLabel = this.decode(dotTailLabel);
            ZestProperties.setSourceLabel((Edge)zest, (String)dotTailLabel);
        }
        String dotStyle = DotAttributes.getStyle((Edge)dot);
        String connectionCssStyle = null;
        if (EdgeStyle.DASHED.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-dash-array: 7 7;";
        } else if (EdgeStyle.DOTTED.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-dash-array: 1 7;";
        } else if (EdgeStyle.BOLD.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-width: 2;";
        } else if (EdgeStyle.INVIS.toString().equals(dotStyle)) {
            ZestProperties.setInvisible((Edge)zest, (Boolean)true);
        }
        if (connectionCssStyle == null) {
            connectionCssStyle = "-fx-stroke-line-cap: butt;";
        }
        if ((dotDir = DotAttributes.getDirParsed((Edge)dot)) == null) {
            dotDir = GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph())) ? DirType.FORWARD : DirType.NONE;
        }
        Color dotColor = null;
        ColorList colorList = DotAttributes.getColorParsed((Edge)dot);
        if (colorList != null && !colorList.getColorValues().isEmpty()) {
            dotColor = ((WC)colorList.getColorValues().get(0)).getColor();
        }
        if ((javaFxColor = this.colorUtil.computeZestColor(dotColorScheme = DotAttributes.getColorscheme((Edge)dot), dotColor)) != null) {
            String zestFill;
            String zestStroke = "-fx-stroke: " + javaFxColor + ";";
            connectionCssStyle = String.valueOf(connectionCssStyle) + zestStroke;
            if (DirType.BACK.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
                zestFill = "-fx-fill: " + javaFxColor + ";";
                zestSourceDecorationCssStyle = String.valueOf(zestStroke) + zestFill;
                ZestProperties.setSourceDecorationCssStyle((Edge)zest, (String)zestSourceDecorationCssStyle);
            }
            if (DirType.FORWARD.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
                zestFill = "-fx-fill: " + javaFxColor + ";";
                String zestTargetDecorationCssStyle = String.valueOf(zestStroke) + zestFill;
                ZestProperties.setTargetDecorationCssStyle((Edge)zest, (String)zestTargetDecorationCssStyle);
            }
        }
        ZestProperties.setCurveCssStyle((Edge)zest, (String)connectionCssStyle);
        Color dotFillColor = DotAttributes.getFillcolorParsed((Edge)dot);
        String javaFxFillColor = this.colorUtil.computeZestColor(dotColorScheme, dotFillColor);
        if (javaFxFillColor != null) {
            zestSourceDecorationCssStyle = ZestProperties.getSourceDecorationCssStyle((Edge)zest);
            ZestProperties.setSourceDecorationCssStyle((Edge)zest, (String)(String.valueOf(zestSourceDecorationCssStyle) + "-fx-fill: " + javaFxFillColor + ";"));
            String zestTargetDecorationCssStyle = ZestProperties.getTargetDecorationCssStyle((Edge)zest);
            ZestProperties.setTargetDecorationCssStyle((Edge)zest, (String)(String.valueOf(zestTargetDecorationCssStyle) + "-fx-fill: " + javaFxFillColor + ";"));
        }
        double arrowSize = (arrowSizeParsed = DotAttributes.getArrowsizeParsed((Edge)dot)) == null ? 1.0 : arrowSizeParsed;
        String dotArrowHead = DotAttributes.getArrowhead((Edge)dot);
        Node zestEdgeTargetDecoration = null;
        if (dotArrowHead == null || DotAttributes.getArrowheadParsed((Edge)dot).getArrowShapes().isEmpty()) {
            if (GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph().getRootGraph()))) {
                zestEdgeTargetDecoration = DotArrowShapeDecorations.getDefault(arrowSize, true);
            }
        } else {
            zestEdgeTargetDecoration = this.computeZestDecoration(DotAttributes.getArrowheadParsed((Edge)dot), arrowSize);
        }
        if (DirType.FORWARD.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
            ZestProperties.setTargetDecoration((Edge)zest, (Node)zestEdgeTargetDecoration);
            this.setStyleOnEdgeTargetDecorationChildren(zest);
        }
        String dotArrowTail = DotAttributes.getArrowtail((Edge)dot);
        Node zestEdgeSourceDecoration = null;
        if (dotArrowTail == null || DotAttributes.getArrowtailParsed((Edge)dot).getArrowShapes().isEmpty()) {
            if (GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph().getRootGraph()))) {
                zestEdgeSourceDecoration = DotArrowShapeDecorations.getDefault(arrowSize, true);
            }
        } else {
            zestEdgeSourceDecoration = this.computeZestDecoration(DotAttributes.getArrowtailParsed((Edge)dot), arrowSize);
        }
        if (DirType.BACK.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
            ZestProperties.setSourceDecoration((Edge)zest, (Node)zestEdgeSourceDecoration);
            this.setStyleOnEdgeSourceDecorationChildren(zest);
        }
        GeometryNode curve = new GeometryNode();
        ZestProperties.setCurve((Edge)zest, (Node)curve);
        if (!this.options().emulateLayout) {
            String dotPos;
            String splines = DotAttributes.getSplines((Graph)dot.getGraph().getRootGraph());
            if (Splines.EMPTY.toString().equals(splines) || Splines.NONE.toString().equals(splines)) {
                ZestProperties.setInvisible((Edge)zest, (Boolean)true);
            }
            if ((dotPos = DotAttributes.getPos((Edge)dot)) != null && !this.options().ignorePositions) {
                List<org.eclipse.gef.geometry.planar.Point> bSplineControlPoints = this.computeZestBSplineControlPoints(dot);
                if (Splines.LINE.toString().equals(splines) || Splines.FALSE.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                } else if (Splines.POLYLINE.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
                } else if (Splines.ORTHO.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new OrthogonalRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, this.computeZestOrthogonalControlPoints(bSplineControlPoints));
                } else if (!Splines.COMPOUND.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new DotBSplineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
                }
            }
            String dotLp = DotAttributes.getLp((Edge)dot);
            if (dotLabel != null && dotLp != null && !this.options().ignorePositions) {
                ZestProperties.setLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getLpParsed((Edge)dot), dotLabel));
            }
            String dotXlp = DotAttributes.getXlp((Edge)dot);
            if (dotXLabel != null && dotXlp != null && !this.options().ignorePositions) {
                ZestProperties.setExternalLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getXlpParsed((Edge)dot), dotXLabel));
            }
            String headLp = DotAttributes.getHeadLp((Edge)dot);
            if (dotHeadLabel != null && headLp != null && !this.options().ignorePositions) {
                ZestProperties.setTargetLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getHeadLpParsed((Edge)dot), dotHeadLabel));
            }
            String tailLp = DotAttributes.getTailLp((Edge)dot);
            if (dotTailLabel != null && tailLp != null && !this.options().ignorePositions) {
                ZestProperties.setSourceLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getTailLpParsed((Edge)dot), dotTailLabel));
            }
        }
    }

    private List<org.eclipse.gef.geometry.planar.Point> computeZestOrthogonalControlPoints(List<org.eclipse.gef.geometry.planar.Point> bSplineControlPoints) {
        ArrayList<org.eclipse.gef.geometry.planar.Point> subList = new ArrayList<org.eclipse.gef.geometry.planar.Point>(bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
        int i = subList.size() - 2;
        while (i > 0) {
            org.eclipse.gef.geometry.planar.Point p = (org.eclipse.gef.geometry.planar.Point)subList.get(i + 1);
            org.eclipse.gef.geometry.planar.Point q = (org.eclipse.gef.geometry.planar.Point)subList.get(i);
            org.eclipse.gef.geometry.planar.Point r = (org.eclipse.gef.geometry.planar.Point)subList.get(i - 1);
            if (p.x == q.x && q.x == r.x || p.y == q.y && q.y == r.y) {
                subList.remove(i);
            }
            --i;
        }
        List<org.eclipse.gef.geometry.planar.Point> subList2 = subList.subList(1, subList.size() - 1);
        return subList2;
    }

    private Node computeZestDecoration(ArrowType arrowType, double arrowSize) {
        return DotArrowShapeDecorations.get(arrowType, arrowSize);
    }

    private String decode(String text) {
        return text.replaceAll("\\\\n", "\n");
    }

    private List<org.eclipse.gef.geometry.planar.Point> computeZestBSplineControlPoints(Edge dot) {
        SplineType splineType = DotAttributes.getPosParsed((Edge)dot);
        ArrayList<org.eclipse.gef.geometry.planar.Point> controlPoints = new ArrayList<org.eclipse.gef.geometry.planar.Point>();
        for (Spline spline : splineType.getSplines()) {
            Point startp = spline.getStartp();
            if (startp == null) {
                startp = (Point)spline.getControlPoints().get(0);
            }
            controlPoints.add(new org.eclipse.gef.geometry.planar.Point(startp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * startp.getY()));
            for (Point cp : spline.getControlPoints()) {
                controlPoints.add(new org.eclipse.gef.geometry.planar.Point(cp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * cp.getY()));
            }
            Point endp = spline.getEndp();
            if (endp == null) {
                endp = (Point)spline.getControlPoints().get(spline.getControlPoints().size() - 1);
            }
            controlPoints.add(new org.eclipse.gef.geometry.planar.Point(endp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * endp.getY()));
        }
        return controlPoints;
    }

    protected void convertAttributes(org.eclipse.gef.graph.Node dot, org.eclipse.gef.graph.Node zest) {
        EscString dotTooltip;
        boolean isRecordBasedShape = false;
        String dotId = DotAttributes.getId((org.eclipse.gef.graph.Node)dot);
        if (dotId != null) {
            ZestProperties.setCssId((org.eclipse.gef.graph.Node)zest, (String)dotId);
        }
        String dotHeight = DotAttributes.getHeight((org.eclipse.gef.graph.Node)dot);
        String dotWidth = DotAttributes.getWidth((org.eclipse.gef.graph.Node)dot);
        double zestWidth = (dotWidth == null ? 0.75 : Double.parseDouble(dotWidth)) * 72.0;
        double zestHeight = (dotHeight == null ? 0.5 : Double.parseDouble(dotHeight)) * 72.0;
        String dotLabel = DotAttributes.getLabel((org.eclipse.gef.graph.Node)dot);
        if (dotLabel == null || dotLabel.equals("\\N")) {
            dotLabel = DotAttributes._getName((org.eclipse.gef.graph.Node)dot);
        }
        boolean isHtmlLabel = DotAttributes.getLabelRaw((org.eclipse.gef.graph.Node)dot) != null ? DotAttributes.getLabelRaw((org.eclipse.gef.graph.Node)dot).getType() == ID.Type.HTML_STRING : false;
        Shape dotShape = DotAttributes.getShapeParsed((org.eclipse.gef.graph.Node)dot);
        StringBuilder zestShapeStyle = this.computeZestStyle(dot, dotShape);
        GeometryNode zestShape = null;
        if (dotShape == null) {
            zestShape = new GeometryNode((IGeometry)new Ellipse(new Rectangle()));
        } else if (dotShape.getShape() instanceof PolygonBasedShape) {
            PolygonBasedNodeShape polygonShape = ((PolygonBasedShape)dotShape.getShape()).getShape();
            zestShape = DotPolygonBasedNodeShapes.get(polygonShape);
        } else if (dotShape.getShape() instanceof RecordBasedShape && !isHtmlLabel) {
            RecordBasedNodeShape recordBasedShape = ((RecordBasedShape)dotShape.getShape()).getShape();
            zestShapeStyle = new StringBuilder(zestShapeStyle.toString().replaceAll("-fx-fill", "-fx-background-color"));
            if (RecordBasedNodeShape.MRECORD.equals((Object)recordBasedShape)) {
                zestShapeStyle.append("-fx-background-radius:10px;-fx-border-radius:10px;");
            }
            if (!zestShapeStyle.toString().contains("-fx-border-style:")) {
                zestShapeStyle.append("-fx-border-style:solid;");
            }
            DotRecordBasedJavaFxNode node = new DotRecordBasedJavaFxNode(dotLabel, DotAttributes.getRankdirParsed((Graph)dot.getGraph()));
            zestShape = node.getFxElement();
            Bounds bounds = node.getBounds();
            zestWidth = Math.max(zestWidth, bounds.getWidth());
            zestHeight = Math.max(zestHeight, bounds.getHeight());
            isRecordBasedShape = true;
        }
        if (zestShape != null) {
            if (zestShapeStyle.length() > 0) {
                zestShape.setStyle(zestShapeStyle.toString());
            }
            ZestProperties.setShape((org.eclipse.gef.graph.Node)zest, (Node)zestShape);
        }
        if (this.isInvisible(dot)) {
            ZestProperties.setInvisible((org.eclipse.gef.graph.Node)zest, (Boolean)true);
        }
        if (isHtmlLabel) {
            DotHTMLLabelJavaFxNode htmlNode = new DotHTMLLabelJavaFxNode(dotLabel);
            ZestProperties.setShape((org.eclipse.gef.graph.Node)zest, (Node)htmlNode.getFxElement());
            Bounds htmlNodeBounds = htmlNode.getBounds();
            zestWidth = htmlNodeBounds.getWidth();
            zestHeight = htmlNodeBounds.getHeight();
        } else if (!isRecordBasedShape) {
            ZestProperties.setLabel((org.eclipse.gef.graph.Node)zest, (String)dotLabel);
        }
        String dotXLabel = DotAttributes.getXlabel((org.eclipse.gef.graph.Node)dot);
        if (dotXLabel != null) {
            ZestProperties.setExternalLabel((org.eclipse.gef.graph.Node)zest, (String)dotXLabel);
        }
        if (this.options().emulateLayout && !Boolean.TRUE.equals(DotAttributes.getFixedsizeParsed((org.eclipse.gef.graph.Node)dot)) && !isRecordBasedShape && !isHtmlLabel) {
            Dimension labelSize = Dot2ZestAttributesConverter.computeZestLabelSize(dotLabel);
            ZestProperties.setSize((org.eclipse.gef.graph.Node)zest, (Dimension)Dimension.max((Dimension)new Dimension(zestWidth, zestHeight), (Dimension)labelSize));
        } else {
            ZestProperties.setSize((org.eclipse.gef.graph.Node)zest, (Dimension)new Dimension(zestWidth, zestHeight));
        }
        String dotPos = DotAttributes.getPos((org.eclipse.gef.graph.Node)dot);
        if (dotPos != null && !this.options().ignorePositions) {
            Point dotPosParsed = DotAttributes.getPosParsed((org.eclipse.gef.graph.Node)dot);
            ZestProperties.setPosition((org.eclipse.gef.graph.Node)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestPosition(dotPosParsed, zestWidth, zestHeight));
            ZestProperties.setLayoutIrrelevant((org.eclipse.gef.graph.Node)zest, (Boolean)dotPosParsed.isInputOnly());
        }
        if ((dotTooltip = DotAttributes.getTooltipParsed((org.eclipse.gef.graph.Node)dot)) != null) {
            String zestTooltip = dotTooltip.getLines().stream().map(JustifiedText::getText).collect(Collectors.joining("\n"));
            ZestProperties.setTooltip((org.eclipse.gef.graph.Node)zest, (String)zestTooltip);
        }
        String dotXlp = DotAttributes.getXlp((org.eclipse.gef.graph.Node)dot);
        if (dotXLabel != null && dotXlp != null && !this.options().ignorePositions) {
            Point dotXlpParsed = DotAttributes.getXlpParsed((org.eclipse.gef.graph.Node)dot);
            ZestProperties.setExternalLabelPosition((org.eclipse.gef.graph.Node)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(dotXlpParsed, dotXLabel));
        }
    }

    private StringBuilder computeZestStyle(org.eclipse.gef.graph.Node dot, Shape dotShape) {
        Style style;
        StringBuilder zestStyle = new StringBuilder();
        Color dotColor = DotAttributes.getColorParsed((org.eclipse.gef.graph.Node)dot);
        String dotColorScheme = DotAttributes.getColorscheme((org.eclipse.gef.graph.Node)dot);
        String javaFxColor = this.colorUtil.computeZestColor(dotColorScheme, dotColor);
        if (javaFxColor != null) {
            zestStyle.append("-fx-stroke: " + javaFxColor + ";");
        }
        if ((style = DotAttributes.getStyleParsed((org.eclipse.gef.graph.Node)dot)) != null) {
            boolean isRecordBasedShape = dotShape != null ? dotShape.getShape() instanceof RecordBasedShape : false;
            for (StyleItem styleItem : style.getStyleItems()) {
                NodeStyle nodeStyle = NodeStyle.get((String)styleItem.getName());
                this.addNodeStyle(zestStyle, nodeStyle, isRecordBasedShape);
            }
        }
        if (this.isFilledStyle(style)) {
            Color dotFillColor = null;
            ColorList fillColor = DotAttributes.getFillcolorParsed((org.eclipse.gef.graph.Node)dot);
            dotFillColor = fillColor != null && !fillColor.getColorValues().isEmpty() ? ((WC)fillColor.getColorValues().get(0)).getColor() : (dotColor != null ? dotColor : DotColors.getDefaultNodeFillColor());
            String javaFxFillColor = this.colorUtil.computeZestColor(dotColorScheme, dotFillColor);
            if (javaFxFillColor != null) {
                zestStyle.append("-fx-fill: " + javaFxFillColor + ";");
            }
        }
        return zestStyle;
    }

    private org.eclipse.gef.geometry.planar.Point computeZestPosition(Point dotPosition, double widthInPixel, double heightInPixel) {
        return new org.eclipse.gef.geometry.planar.Point(dotPosition.getX() - widthInPixel / 2.0, (double)(this.options().invertYAxis ? -1 : 1) * dotPosition.getY() - heightInPixel / 2.0);
    }

    private org.eclipse.gef.geometry.planar.Point computeZestLabelPosition(Point dotLabelPosition, String labelText) {
        Dimension labelSize = Dot2ZestAttributesConverter.computeZestLabelSize(labelText);
        return this.computeZestPosition(dotLabelPosition, labelSize.getWidth(), labelSize.getHeight());
    }

    static Dimension computeZestLabelSize(String labelText) {
        Bounds layoutBounds = new Text(labelText).getLayoutBounds();
        return new Dimension(layoutBounds.getWidth(), layoutBounds.getHeight());
    }

    private void addNodeStyle(StringBuilder zestStyle, NodeStyle style, boolean isRecordBasedNode) {
        if (isRecordBasedNode) {
            switch (style) {
                case BOLD: {
                    zestStyle.append("-fx-border-width: 2;");
                    break;
                }
                case DASHED: {
                    zestStyle.append("-fx-border-style:dashed;");
                    break;
                }
                case DIAGONALS: {
                    break;
                }
                case DOTTED: {
                    zestStyle.append("-fx-border-style:dotted;");
                    break;
                }
                case RADIAL: {
                    break;
                }
                case ROUNDED: {
                    break;
                }
                case SOLID: {
                    zestStyle.append("-fx-border-style:solid;");
                    break;
                }
                case STRIPED: {
                    break;
                }
            }
        } else {
            switch (style) {
                case BOLD: {
                    zestStyle.append("-fx-stroke-width:2;");
                    break;
                }
                case DASHED: {
                    zestStyle.append("-fx-stroke-dash-array: 7 7;");
                    break;
                }
                case DIAGONALS: {
                    break;
                }
                case DOTTED: {
                    zestStyle.append("-fx-stroke-dash-array: 1 6;");
                    break;
                }
                case RADIAL: {
                    break;
                }
                case ROUNDED: {
                    break;
                }
                case SOLID: {
                    zestStyle.append("-fx-stroke-width: 1;");
                    break;
                }
                case STRIPED: {
                    break;
                }
            }
        }
    }

    private boolean isInvisible(org.eclipse.gef.graph.Node dot) {
        Style nodeStyle = DotAttributes.getStyleParsed((org.eclipse.gef.graph.Node)dot);
        if (nodeStyle != null) {
            for (StyleItem styleItem : nodeStyle.getStyleItems()) {
                if (!styleItem.getName().equals(NodeStyle.INVIS.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFilledStyle(Style nodeStyle) {
        if (nodeStyle != null) {
            for (StyleItem styleItem : nodeStyle.getStyleItems()) {
                if (!styleItem.getName().equals(NodeStyle.FILLED.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private void setStyleOnEdgeSourceDecorationChildren(Edge edge) {
        Node sourceDecoration = ZestProperties.getSourceDecoration((Edge)edge);
        String sourceDecorationStyle = ZestProperties.getSourceDecorationCssStyle((Edge)edge);
        this.setStyleOnEdgeDecorationChildren(sourceDecoration, sourceDecorationStyle);
    }

    private void setStyleOnEdgeTargetDecorationChildren(Edge edge) {
        Node targetDecoration = ZestProperties.getTargetDecoration((Edge)edge);
        String targetDecorationStyle = ZestProperties.getTargetDecorationCssStyle((Edge)edge);
        this.setStyleOnEdgeDecorationChildren(targetDecoration, targetDecorationStyle);
    }

    private void setStyleOnEdgeDecorationChildren(Node edgeDecoration, String style) {
        if (edgeDecoration instanceof Group) {
            Group group = (Group)edgeDecoration;
            for (Node child : group.getChildren()) {
                child.setStyle(style);
            }
        }
    }

    protected void convertAttributes(Graph dot, Graph zest) {
        if (this.options().emulateLayout) {
            Rankdir dotRankdir;
            String dotLayout = DotAttributes.getLayout((Graph)dot);
            Object algo = null;
            algo = Layout.CIRCO.toString().equals(dotLayout) || Layout.NEATO.toString().equals(dotLayout) || Layout.TWOPI.toString().equals(dotLayout) ? new RadialLayoutAlgorithm() : (Layout.FDP.toString().equals(dotLayout) || Layout.SFDP.toString().equals(dotLayout) ? new SpringLayoutAlgorithm() : (Layout.OSAGE.toString().equals(dotLayout) ? new GridLayoutAlgorithm() : new TreeLayoutAlgorithm(Rankdir.LR.equals((Object)(dotRankdir = DotAttributes.getRankdirParsed((Graph)dot))) ? 3 : 1)));
            ZestProperties.setLayoutAlgorithm((Graph)zest, (ILayoutAlgorithm)algo);
        }
    }

    public Options options() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public static final class Options {
        public boolean emulateLayout = true;
        public boolean ignorePositions = false;
        public boolean invertYAxis = false;
    }
}

