/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.instantiation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetsUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.instantiation.ListDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiationMethodService {
    private final List<InstantiationMethod> launchedInstMeth;
    private final TableCommandFactory tableCmdFactory;
    private final Table table;
    private final EditingDomain editingDomain;

    public InstantiationMethodService(Table table, TableCommandFactory tableCmdFactory, EditingDomain editingDomain) {
        this.table = table;
        this.tableCmdFactory = tableCmdFactory;
        this.editingDomain = editingDomain;
        this.launchedInstMeth = new ArrayList<InstantiationMethod>();
        TableConfiguration tableConfig = this.table.getTableConfiguration();
        if (tableConfig != null && tableConfig.getInstantiationMethod() != null) {
            for (InstantiationMethod meth : tableConfig.getInstantiationMethod()) {
                this.launchedInstMeth.add(meth);
            }
        }
    }

    public final List<InstantiationMethod> getInstantiationMethodHistory() {
        return this.launchedInstMeth;
    }

    public final void selectInstantiationMethodToLaunch() {
        Object[] dResult;
        ListDialog dialog = new ListDialog(Display.getDefault().getActiveShell());
        dialog.setInput(this.launchedInstMeth);
        dialog.setTitle(Messages.NatTableWidget_instantiationMethodSelectionTitle);
        if (dialog.open() != 1 && (dResult = dialog.getResult()).length != 0 && dResult[0] instanceof InstantiationMethod) {
            InstantiationMethod meth = (InstantiationMethod)dialog.getResult()[0];
            this.launchedInstMeth.remove(meth);
            this.launchedInstMeth.add(0, meth);
            this.createNewElement();
        }
    }

    public final void createNewElement() {
        if (this.launchedInstMeth.isEmpty() || this.launchedInstMeth.get(0) == null) {
            this.selectInstantiationMethodToLaunch();
        } else {
            this.createNewElement(this.launchedInstMeth.get(0));
        }
    }

    public final void createNewElement(InstantiationMethod instantMethod) {
        try {
            EOperation eOperation = instantMethod.getInstantiationOperation();
            if (eOperation != null) {
                EObject context = this.table.getContext();
                if (context == null) {
                    throw new IllegalStateException("The table context must not be null when invoking an instantiation method");
                }
                IFacetManager facetManager = FacetsUtils.getFacetManager((EObject)this.table);
                EObject queryResult = (EObject)facetManager.invoke(context, eOperation, EObject.class, this.editingDomain, new Object[]{this.table.getParameter(), this.editingDomain});
                ArrayList<EObject> list = new ArrayList<EObject>();
                list.add(queryResult);
                this.addRows(list);
                this.launchedInstMeth.remove(instantMethod);
                this.launchedInstMeth.add(0, instantMethod);
            }
        }
        catch (Exception e) {
            throw new TableWidgetRuntimeException(e);
        }
    }

    private final void addRows(List<? extends EObject> newElements) {
        Command cmd = this.tableCmdFactory.createAddRowsCommand(newElements);
        EditingDomainUtils.executeCommand(cmd, this.editingDomain);
    }
}

