/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialog;
import org.eclipse.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialogFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialog;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogFactory;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IQuestionDialog;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IQuestionDialogFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandFactoryUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom.FacetAndCustomCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.utils.EditingDomainUtils;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetAndCustomService {
    private final Table table;
    private final FacetAndCustomCommandFactory fctCustCmdFactory;
    private final EditingDomain editingDomain;

    public FacetAndCustomService(Table table, BasicCommandFactory basicCmdFactory) {
        this.table = table;
        this.fctCustCmdFactory = new FacetAndCustomCommandFactory(table, basicCmdFactory);
        this.editingDomain = basicCmdFactory.getEditingDomain();
    }

    public final void openLoadCustomizationDialog() {
        HashSet availCustomsSet = new HashSet();
        ResourceSet resourceSet = this.table.eResource().getResourceSet();
        availCustomsSet.addAll(ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(resourceSet).getRegisteredCustomizations());
        availCustomsSet.addAll(this.table.getCustomizations());
        ArrayList availCustomsList = new ArrayList(availCustomsSet);
        IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog>(){

            public void committed(List<Customization> result, Boolean precommitResult) {
                if (precommitResult.booleanValue()) {
                    FacetAndCustomService.this.loadCustomizations(result);
                }
            }

            public IQuestionDialog openPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
                return FacetAndCustomService.this.openLoadCustomizationPrecommitDialog(result, precommitCallback);
            }
        };
        ILoadCustomizationsDialog dialog = ILoadCustomizationsDialogFactory.DEFAULT.createLoadCustomizationDialog(null, availCustomsList, (List)this.table.getCustomizations(), (List)this.table.getLocalCustomizations(), (IDialogCallbackWithPreCommit)callback, "It is used to store the hidden columns.");
        dialog.asyncOpen();
    }

    protected IQuestionDialog openLoadCustomizationPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
        ArrayList removedCustoms = new ArrayList();
        removedCustoms.addAll(this.table.getCustomizations());
        removedCustoms.removeAll(result);
        ArrayList<FacetSet> newFacetSets = new ArrayList<FacetSet>();
        newFacetSets.addAll((Collection<FacetSet>)this.table.getFacetSets());
        newFacetSets.removeAll(removedCustoms);
        return this.openFacetSetLoadPrecommitDialog(newFacetSets, precommitCallback);
    }

    public final void openLoadFacetSetsDialog() {
        HashSet<FacetSet> availableFSets = new HashSet<FacetSet>();
        ResourceSet resourceSet = this.table.eResource().getResourceSet();
        availableFSets.addAll(IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet).getRegisteredFacetSets());
        if (this.table.getTableConfiguration() != null) {
            for (Facet facet : this.table.getTableConfiguration().getDefaultFacets()) {
                availableFSets.add(FacetUtils.getRootFacetSet((Facet)facet));
            }
        }
        for (FacetSet facetSet : this.table.getFacetSets()) {
            availableFSets.add(FacetUtils.getRootFacetSet((FacetSet)facetSet));
        }
        IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, IQuestionDialog>(){

            public void committed(List<FacetSet> result, Boolean precommitResult) {
                if (precommitResult.booleanValue()) {
                    FacetAndCustomService.this.setLoadedFacetSets(result);
                }
            }

            public IQuestionDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                return FacetAndCustomService.this.openFacetSetLoadPrecommitDialog(result, precommitCallback);
            }
        };
        IFacetSetSelectionDialog dialog = IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(availableFSets, Integer.MAX_VALUE, true, (IDialogCallbackWithPreCommit)callback, Display.getDefault().getActiveShell());
        dialog.setSelectedFacetSets((List)this.table.getFacetSets());
    }

    public final void loadCustomizations(List<Customization> customsToLoad) {
        Command cmd = this.fctCustCmdFactory.createSetCustomizationCommand(customsToLoad);
        EditingDomainUtils.executeCommand(cmd, this.editingDomain);
    }

    public void setLoadedFacetSets(List<FacetSet> facetSets) {
        Command cmd = this.fctCustCmdFactory.createSetLoadedFacetSetsCommand(facetSets);
        EditingDomainUtils.executeCommand(cmd, this.editingDomain);
    }

    protected IQuestionDialog openFacetSetLoadPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
        IQuestionDialog dialog = null;
        if (!CommandFactoryUtils.columnsToRemove(this.table, result, (List<Row>)this.table.getRows()).isEmpty()) {
            final IQuestionDialog finalDialog = IQuestionDialogFactory.INSTANCE.createQuestionDialog(Display.getDefault().getActiveShell(), Messages.TableWidgetController_Remove_columns_after_facetSet_setting_short, Messages.TableWidgetController_Remove_columns_after_facetSet_setting_long, precommitCallback);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    finalDialog.open();
                }
            });
            dialog = finalDialog;
        }
        return dialog;
    }

    public FacetAndCustomCommandFactory getFctCustCmdFactory() {
        return this.fctCustCmdFactory;
    }
}

