/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.celleditors.internal.core.composite;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.util.swt.fontprovider.IFontProvider;
import org.eclipse.emf.facet.util.swt.fontprovider.IFontProviderFactory;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.emf.facet.widgets.celleditors.internal.Messages;
import org.eclipse.emf.facet.widgets.internal.CustomizableLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryReferenceCellEditorComposite
extends AbstractCellEditorComposite<EObject> {
    private static final int GRID_DATA_HEIGHT = 50;
    private final Button button;
    private final Combo combo;
    private final Control parentControl;
    private final Map<String, EObject> fElements = new TreeMap<String, EObject>();

    public UnaryReferenceCellEditorComposite(final Composite parent, final List<EObject> eObjects) {
        super(parent);
        this.parentControl = parent;
        CustomizableLabelProvider customizableLabelProvider = new CustomizableLabelProvider();
        for (EObject eObject : eObjects) {
            String label = customizableLabelProvider.getText(eObject);
            if (this.fElements.get(label) != null) {
                int suffix = 2;
                while (this.fElements.get(String.valueOf(label) + " (" + suffix + ")") != null) {
                    ++suffix;
                }
                this.fElements.put(String.valueOf(label) + " (" + suffix + ")", eObject);
                continue;
            }
            this.fElements.put(label, eObject);
        }
        GridLayout compositeLayout = new GridLayout(2, false);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.horizontalSpacing = 0;
        this.setLayout((Layout)compositeLayout);
        this.combo = new Combo((Composite)this, 4);
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        fontData[0].setHeight(fontData[0].getHeight() - 2);
        IFontProvider fontProvider = IFontProviderFactory.DEFAULT.getOrCreateIFontProvider((Device)Display.getDefault());
        Font font = fontProvider.getFont(fontData[0]);
        this.combo.setFont(font);
        for (String label : this.fElements.keySet()) {
            this.combo.add(label);
        }
        GridData comboGridData = new GridData(4, 4, true, true);
        this.combo.setLayoutData((Object)comboGridData);
        UnaryReferenceCellEditorComposite.addCompletionHandler(this.combo, this.fElements.keySet());
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    if (UnaryReferenceCellEditorComposite.this.isValid()) {
                        UnaryReferenceCellEditorComposite.this.commit();
                    } else {
                        MessageDialog.openWarning((Shell)parent.getShell(), (String)Messages.UnaryReferenceCellEditorComposite_0, (String)Messages.UnaryReferenceCellEditorComposite_1);
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    UnaryReferenceCellEditorComposite.this.close();
                }
            }
        });
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData buttonGridData = new GridData(4, 4, false, true);
        buttonGridData.heightHint = 50;
        this.button.setLayoutData((Object)buttonGridData);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(UnaryReferenceCellEditorComposite.this.getParentControl().getShell(), (ILabelProvider)new CustomizableLabelProvider()){

                    protected void okPressed() {
                        Object[] selectedElements = this.getSelectedElements();
                        String selectedElementLabel = null;
                        if (selectedElements.length > 0) {
                            Set<Map.Entry<String, EObject>> entrySet = UnaryReferenceCellEditorComposite.this.getfElements().entrySet();
                            for (Map.Entry<String, EObject> entry : entrySet) {
                                if (entry.getValue() != selectedElements[0]) continue;
                                selectedElementLabel = entry.getKey();
                                break;
                            }
                        }
                        UnaryReferenceCellEditorComposite.this.getCombo().setText(selectedElementLabel);
                        UnaryReferenceCellEditorComposite.this.commit();
                        super.okPressed();
                    }
                };
                dialog.setTitle(Messages.UnaryReferenceCellEditorComposite_2);
                dialog.setElements(eObjects.toArray());
                dialog.open();
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == UnaryReferenceCellEditorComposite.this.getParentControl().getShell() && event.widget != UnaryReferenceCellEditorComposite.this.getButton() && event.widget != UnaryReferenceCellEditorComposite.this.getCombo() && UnaryReferenceCellEditorComposite.this.isValid()) {
                    UnaryReferenceCellEditorComposite.this.commit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UnaryReferenceCellEditorComposite.this.fireChanged();
            }
        });
        this.combo.forceFocus();
    }

    protected boolean isValid() {
        return this.fElements.get(this.combo.getText()) != null;
    }

    private static void addCompletionHandler(Combo comboBox, Collection<String> completions) {
        String[] completionsArray = completions.toArray(new String[completions.size()]);
        SimpleContentProposalProvider contentProposalProvider = new SimpleContentProposalProvider(completionsArray);
        contentProposalProvider.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)comboBox, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)contentProposalProvider, null, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    @Override
    public EObject getValue() {
        EObject eObject = this.fElements.get(this.combo.getText());
        return eObject;
    }

    protected void commit() {
        this.fireCommit();
    }

    @Override
    public void setValue(EObject value) {
    }

    protected Button getButton() {
        return this.button;
    }

    protected Combo getCombo() {
        return this.combo;
    }

    protected Control getParentControl() {
        return this.parentControl;
    }

    protected Map<String, EObject> getfElements() {
        return this.fElements;
    }
}

