/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.ocl.core.util;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OclQueryUtil {
    private static OCL<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> oclEnvironment = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
    private static OCLHelper<EClassifier, EOperation, EStructuralFeature, Constraint> oclHelper = OclQueryUtil.getOCLEnvironment().createOCLHelper();

    private OclQueryUtil() {
    }

    private static OCL<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getOCLEnvironment() {
        return oclEnvironment;
    }

    public static EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> getEvaluationEvironment() {
        return OclQueryUtil.getOCLEnvironment().getEvaluationEnvironment();
    }

    private static OCLHelper<EClassifier, EOperation, EStructuralFeature, Constraint> getOCLHelper() {
        return oclHelper;
    }

    private static void setHelperContext(EClassifier context) {
        OclQueryUtil.getOCLHelper().setContext((Object)context);
    }

    public static void setHelperInstanceContext(Object context) {
        OclQueryUtil.getOCLHelper().setInstanceContext(context);
    }

    public static OCLExpression<EClassifier> createOCLExpression(EClassifier context, String expression) throws ParserException {
        OclQueryUtil.setHelperContext(context);
        return OclQueryUtil.getOCLHelper().createQuery(expression);
    }

    public static Object evaluateQuery(EClassifier context, OCLExpression<EClassifier> oclExpression) {
        OclQueryUtil.setHelperContext(context);
        return OclQueryUtil.getOCLEnvironment().createQuery(oclExpression).evaluate();
    }

    public static Object evaluateQuery(EClassifier context, OCLExpression<EClassifier> oclExpression, Object objectSource) {
        OclQueryUtil.setHelperContext(context);
        return OclQueryUtil.getOCLEnvironment().createQuery(oclExpression).evaluate(objectSource);
    }

    public static Object evaluateQuery(EClassifier context, OCLExpression<EClassifier> oclExpression, List<?> objectsSource) {
        OclQueryUtil.setHelperContext(context);
        return OclQueryUtil.getOCLEnvironment().createQuery(oclExpression).evaluate(objectsSource);
    }

    public static List<Choice> getSyntaxHelp(EClassifier context, String expression) {
        OclQueryUtil.setHelperContext(context);
        return OclQueryUtil.getOCLHelper().getSyntaxHelp(ConstraintKind.INVARIANT, expression);
    }

    public static EClassifier getEClassifier(EClassifier context, Object type) {
        EClassifier result = null;
        String name = null;
        EList classifiers = null;
        if (type instanceof PrimitiveType) {
            name = ((PrimitiveType)type).getInstanceClassName();
            classifiers = EcorePackage.eINSTANCE.getEClassifiers();
        } else if (type instanceof EClass) {
            name = ((EClass)type).getInstanceClassName();
            classifiers = context.getEPackage().getEClassifiers();
        } else if (type instanceof CollectionType) {
            name = ((EClassifier)((CollectionType)type).getElementType()).getInstanceClassName();
            classifiers = context.getEPackage().getEClassifiers();
        } else {
            name = type.getClass().getName();
            classifiers = EcorePackage.eINSTANCE.getEClassifiers();
        }
        for (EClassifier classifier : classifiers) {
            String instanceClassName = classifier.getInstanceClassName();
            if (!instanceClassName.equals(name)) continue;
            result = classifier;
            break;
        }
        return result;
    }

    public static boolean compareClassifierTypes(EClassifier firstType, EClassifier secondType) {
        boolean result = false;
        if (firstType.getName().equals(secondType.getName())) {
            result = true;
        } else if (firstType.getName().contains(secondType.getName()) || secondType.getName().contains(firstType.getName())) {
            result = true;
        }
        return result;
    }

    public static Object getExpressionType(OCLExpression<?> expression) {
        Object result = null;
        if (expression instanceof IteratorExp) {
            Object type = ((IteratorExp)expression).getType();
            result = ((CollectionType)type).getElementType();
        } else {
            result = expression.getType();
        }
        return result;
    }
}

