/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.scm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.FilterOperations;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.FilteredOperationsResult;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.ProxyInitializer;
import org.eclipse.emf.emfstore.internal.client.ui.views.scm.VirtualNode;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.OperationProxy;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCMContentProvider
extends AdapterFactoryContentProvider {
    private boolean showRootNodes = true;
    private boolean reverseNodes = true;
    private final Map<ChangePackage, VirtualNode<AbstractOperation>> changePackageToFilteredMapping = new LinkedHashMap<ChangePackage, VirtualNode<AbstractOperation>>();
    private final Map<ChangePackage, List<Object>> changePackageToNonFilteredMapping = new LinkedHashMap<ChangePackage, List<Object>>();
    private ModelElementIdToEObjectMapping idToEObjectMapping;
    private ProxyInitializer proxyInitializer;

    public SCMContentProvider() {
        super((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }

    public SCMContentProvider(ModelElementIdToEObjectMapping idToEObjectMapping) {
        this();
        this.idToEObjectMapping = idToEObjectMapping;
    }

    public void setReverseNodes(boolean reverseNodes) {
        this.reverseNodes = reverseNodes;
    }

    public boolean isReverseNodes() {
        return this.reverseNodes;
    }

    public Object[] getElements(Object object) {
        if (object instanceof List && this.showRootNodes) {
            List list = (List)object;
            ArrayList result = new ArrayList(list.size());
            result.addAll(list);
            return result.toArray();
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return list.toArray();
            }
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            if (this.isListOf(list, HistoryInfo.class)) {
                for (HistoryInfo info : list) {
                    if (info.getChangePackage() == null) continue;
                    result.addAll(this.getReversedOperations(info.getChangePackage()));
                }
            } else if (this.isListOf(list, AbstractOperation.class)) {
                FilteredOperationsResult filteredOpsResult = new FilterOperations(this.idToEObjectMapping).filter(list.toArray());
                result.addAll(filteredOpsResult.getNonFiltered());
                if (filteredOpsResult.getFilteredOperations().size() > 0) {
                    VirtualNode<AbstractOperation> node = new VirtualNode<AbstractOperation>(filteredOpsResult.getFilteredOperations());
                    result.add(node);
                }
            } else {
                for (ChangePackage changePackage : list) {
                    result.addAll(this.getReversedOperations((AbstractChangePackage)changePackage));
                }
            }
            return result.toArray();
        }
        if (object instanceof EObject) {
            return new Object[]{object};
        }
        return super.getElements(object);
    }

    private List<OperationProxy> getReversedOperations(AbstractChangePackage changePackage) {
        ESCloseableIterable operations = changePackage.operations();
        ArrayList<OperationProxy> operationProxies = new ArrayList<OperationProxy>();
        ChangePackageVisualizationHelper changePackageVisualizationHelper = new ChangePackageVisualizationHelper(this.idToEObjectMapping);
        try {
            Iterable operationIterable = operations.iterable();
            for (AbstractOperation abstractOperation : operationIterable) {
                OperationProxy operationProxy = VersioningFactory.eINSTANCE.createOperationProxy();
                operationProxy.setLabel(changePackageVisualizationHelper.getDescription(abstractOperation));
                operationProxies.add(0, operationProxy);
            }
        }
        finally {
            operations.close();
        }
        return operationProxies;
    }

    private boolean isListOf(List<?> list, Class<? extends EObject> clazz) {
        Object firstElement = list.get(0);
        return clazz.isInstance(firstElement);
    }

    private void filter(ChangePackage changePackage, Object[] input, Class<? extends EObject> clazz) {
        if (this.changePackageHasBeenFiltered((AbstractChangePackage)changePackage)) {
            return;
        }
        FilteredOperationsResult result = new FilterOperations(this.idToEObjectMapping, clazz).filter(input);
        VirtualNode<AbstractOperation> node = new VirtualNode<AbstractOperation>(result.getFilteredOperations());
        this.changePackageToNonFilteredMapping.put(changePackage, result.getNonFiltered());
        this.changePackageToFilteredMapping.put(changePackage, node);
    }

    private boolean changePackageHasBeenFiltered(AbstractChangePackage changePackage) {
        return this.changePackageToNonFilteredMapping.containsKey(changePackage);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof FileBasedChangePackage) {
            return true;
        }
        if (object instanceof OperationProxy) {
            return true;
        }
        return this.getChildren(object).length > 0;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof OperationProxy) {
            OperationProxy proxy = (OperationProxy)OperationProxy.class.cast(object);
            FileBasedChangePackage changePackage = (FileBasedChangePackage)proxy.eContainer();
            AbstractOperation abstractOperation = changePackage.get(proxy.getIndex());
            return this.getChildren(abstractOperation);
        }
        if (object instanceof HistoryInfo) {
            HistoryInfo historyInfo = (HistoryInfo)object;
            return this.getChildren(historyInfo.getChangePackage());
        }
        if (object instanceof FileBasedChangePackage) {
            FileBasedChangePackage changePackage = (FileBasedChangePackage)object;
            this.createOperationProxies(changePackage);
            return changePackage.getOperationProxies().toArray();
        }
        if (object instanceof ChangePackage) {
            ArrayList<VirtualNode<AbstractOperation>> result = new ArrayList<VirtualNode<AbstractOperation>>();
            ChangePackage changePackage = (ChangePackage)object;
            this.filter(changePackage, super.getChildren(object), LogMessage.class);
            result.addAll((Collection)this.changePackageToNonFilteredMapping.get(changePackage));
            VirtualNode<AbstractOperation> node = this.changePackageToFilteredMapping.get(changePackage);
            if (node.getContent().size() > 0) {
                result.add(node);
            }
            return result.toArray();
        }
        if (object instanceof VirtualNode) {
            return ((VirtualNode)object).getContent().toArray();
        }
        if (object instanceof CompositeOperation) {
            return ((CompositeOperation)object).getSubOperations().toArray();
        }
        return super.getChildren(object);
    }

    private void createOperationProxies(FileBasedChangePackage changePackage) {
        ESCloseableIterable operations = changePackage.operations();
        int opIndex = 0;
        ArrayList<OperationProxy> updatedProxies = new ArrayList<OperationProxy>();
        try {
            for (AbstractOperation operation : operations.iterable()) {
                OperationProxy newProxy = SCMContentProvider.createProxy(operation);
                if (this.proxyInitializer != null) {
                    this.proxyInitializer.prepareProxy(newProxy, operation);
                }
                newProxy.setIndex(opIndex);
                updatedProxies.add(newProxy);
                ++opIndex;
            }
        }
        finally {
            operations.close();
        }
        changePackage.getOperationProxies().clear();
        changePackage.getOperationProxies().addAll(updatedProxies);
    }

    private static OperationProxy createProxy(AbstractOperation operation) {
        OperationProxy newProxy = VersioningFactory.eINSTANCE.createOperationProxy();
        if (CompositeOperation.class.isInstance(operation)) {
            CompositeOperation compositeOperation = (CompositeOperation)operation;
            EList leafOperations = compositeOperation.getSubOperations();
            for (AbstractOperation op : leafOperations) {
                newProxy.getProxies().add((Object)SCMContentProvider.createProxy(op));
            }
        }
        return newProxy;
    }

    public boolean isShowRootNodes() {
        return this.showRootNodes;
    }

    public void setShowRootNodes(boolean showRootNodes) {
        this.showRootNodes = showRootNodes;
    }

    public void setProxyInitializer(ProxyInitializer proxyInitializer) {
        this.proxyInitializer = proxyInitializer;
    }
}

