/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.handler;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.xcore.formatting.XcoreImportOrganizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XcoreOrganizeImportsHandler
extends AbstractHandler {
    @Inject
    private XcoreImportOrganizer xcoreImportOrganizer;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
        if (editor != null) {
            IXtextDocument document = editor.getDocument();
            this.doOrganizeImports(document);
        }
        return null;
    }

    public void doOrganizeImports(IXtextDocument document) {
        Pair result = (Pair)document.readOnly((IUnitOfWork)new IUnitOfWork<Pair<Region, String>, XtextResource>(){

            public Pair<Region, String> exec(XtextResource xtextResource) throws Exception {
                String organizedImportSection;
                TextRegion importRegion = XcoreOrganizeImportsHandler.this.xcoreImportOrganizer.getImportRegion(xtextResource);
                if (importRegion != null && (organizedImportSection = XcoreOrganizeImportsHandler.this.xcoreImportOrganizer.getOrganizedImportSection(xtextResource)) != null) {
                    return Tuples.create((Object)new Region(importRegion.getOffset(), importRegion.getLength()), (Object)organizedImportSection);
                }
                return null;
            }
        });
        if (result != null) {
            try {
                Region region = (Region)result.getFirst();
                String importSection = (String)result.getSecond();
                int offset = region.getOffset();
                int length = region.getLength();
                String string = document.get(offset, length);
                if (!string.equals(importSection)) {
                    document.replace(offset, length, importSection);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

